package org.opengion.hayabusa.servlet;

import org.opengion.fukurou.util.LogWriter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;

public class TestCometServlet extends HttpServlet  implements CometProcessor {
	private static final long serialVersionUID = 400020070911L;

	private static final int    TIMEOUT		 = 60 * 1000 * 30 ;	// (ms)
	private static final String CONTENT_TYPE = "text/html;charset=UTF-8" ;
	private static final String HTML_HEADER  =
					"<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n"
				+	"<head><title>TestCometServlet Message</title></head>\n"
				+	"<body>" ;
	private static final String HTML_FOOTER  = "</body></html>" ;

	private final List<HttpServletResponse> responses = new ArrayList<HttpServletResponse>();

	public void event( final CometEvent event ) throws IOException, ServletException {
		final HttpServletRequest request = event.getHttpServletRequest();

System.out.println( request.getMethod() + " : " + event.getEventType() );

		if( "POST".equals(request.getMethod() )) { 	// 送信されたメッセージ
			callPOST( request );
			event.close();
		}
		else {
			final HttpServletResponse response = event.getHttpServletResponse();
			response.setContentType( CONTENT_TYPE );
			final PrintWriter writer = response.getWriter();
			switch( event.getEventType() ) {
				case BEGIN :	// コネクション確立
					// タイムアウトの設定
					event.setTimeout( TIMEOUT );
					callBEGIN( writer );
					addResponce(response);
callPOST( request );
					break;
				case READ :		// データ入力
					removeResponce(response);
					callREAD( writer );
					event.close();
					break;
				case END :		// リクエスト終了
					removeResponce(response);
					callEND( writer );
					event.close();
					break;
				case ERROR :	// エラー
					removeResponce(response);
					callERROR( writer );
					event.close();
					break;
				default:		// ありえないはず。
					removeResponce(response);
					event.close();
					break;
			}
		}
	}

	private void callPOST( final HttpServletRequest request ) {
		final String user	 = request.getParameter("user");
		final String message = request.getParameter("message");
		System.out.println( user + "> " + message );
		// 全てのクライアントへ送信
		if( user != null ) {
			sendMessage( user + "> " + message + "<br/>" );
		}
	}

	private void callBEGIN( final PrintWriter writer ) {
		System.out.println( "コネクション確立" );
		writer.println( HTML_HEADER );
		// バッファの問題か、最初にある程度データを入力しないと、表示されません。
		writer.println( "ようこそ、お越しくださいました。comet の実験コーナーです。<br/>" );
		writer.println( "このメッセージは、コネクション成立ユーザーにのみ、返信しています。<br/>" );
		writer.flush();
	}

	private void callREAD( final PrintWriter writer ) {
		System.out.println( "データ入力" );
		writer.println( HTML_FOOTER );
	}

	private void callEND( final PrintWriter writer ) {
		System.out.println( "リクエスト終了" );
		writer.println( HTML_FOOTER );
	}

	private void callERROR( final PrintWriter writer ) {
		System.out.println( "エラー" );
	}

	private void addResponce( final HttpServletResponse response ) {
		synchronized( responses ) {
			responses.add( response );
		}
	}

	private void removeResponce( final HttpServletResponse response ) {
		synchronized( responses ) {
			responses.remove( response );
		}
	}

	public void sendMessage( final String message ) {
		final HttpServletResponse[] resp ;

		synchronized( responses ) {
			resp = responses.toArray( new HttpServletResponse[responses.size()] );
		}

		PrintWriter writer ;
		if( resp != null ) {
//			for( int i=0; ( resp != null && i<resp.length ); i++ ) {
			for( int i=0; i<resp.length; i++ ) {
				try {
					writer = resp[i].getWriter();
					writer.println( message );
					writer.flush();
				} catch( IOException e ) {
					LogWriter.log( e );
				}
			}
		}
	}
}
