/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.view;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * エントリ形式フォーム作成クラスです。
 *
 * フォーマットを外部から指定することにより､自由にレイアウトを作成できます。
 *
 * AbstractViewForm により、setter/getterメソッドのデフォルト実装を提供しています。
 * 各HTMLのタグに必要な setter/getterメソッドのみ，追加定義しています。
 *
 * AbstractViewForm を継承している為,ロケールに応じたラベルを出力させる事が出来ます。
 *
 * @og.rev 3.1.8.0 (2003/05/16) ViewForm_HTMLEntry クラスの新規作成
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class ViewForm_HTMLEntry extends ViewForm_HTMLFormatTextField {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	// 4.3.4.4 (2009/01/01)
//	/**
//	 * デフォルトコンストラクター
//	 *
//	 */
//	public ViewForm_HTMLEntry() {
//		super();
//	}

	/**
	 * row行，colum列 のデータの値をHTML文字列に変換して返します。
	 * Entry 系のため、通常の行番号付の Editor ではなく、行番号無しの
	 * Editorを使用して、HTML文字列を作成します。
	 *
	 * @og.rev 3.8.0.9 (2005/10/17) writableControl 追加による引数変更
	 *
	 * @param	row int
	 * @param	column int
	 * @param	inVal String
	 * @return	row行，colum列 のデータの値
	 */
	protected String getEditorValue( final int row, final int column , final String inVal ) {
		return getDBColumn(column).getEditorValue( inVal );
	}

	/**
	 * 画面に選択された番号を表示します。
	 * Entry 系のため、選択番号を作成しません。
	 *
	 * @param  row	 行番号
	 * @return	0Byte 文字列 ""（固定）
	 */
	protected String makeSelectNo( final int row ) {
		return "" ;
	}

	/**
	 * 初期化します。
	 * このクラスでは、データが０件の場合は、初期データを１件作成します。
	 * 初期化時に、初期データ作成処理を行います。
	 *
	 * @og.rev 3.2.3.0 (2003/06/06) 新規追加
	 * @og.rev 3.5.6.0 (2004/06/18) null 比較でバグを修正
	 * @og.rev 3.5.6.1 (2004/06/25) lang 言語コード 属性を削除します。
	 * @og.rev 4.0.1.0 (2007/12/12) initの場所を変更
	 *
	 * @param	table DBTableModel
	 */
	public void init( final DBTableModel table ) {
	//	super.init( table );
		if( table != null && table.getRowCount() == 0 ) {
			String[] data = new String[table.getColumnCount()];
			for( int i=0; i<data.length; i++ ) {
				data[i] = table.getDBColumn(i).getDefault();
				if( data[i] == null ) { data[i] = ""; }
			}
			table.addValues( data,0 );
		}
		super.init( table ); // 4.0.1.0 (2007/12/12)　0件時不具合対応につき場所変更
	}
}
