<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <xsl:variable name="version" select="version" />
    <ROWSET tableName="GF24">
      <EXEC_SQL>delete from GF24 where VERSION = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="classDoc/method">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="method" />
          </xsl:attribute>
          <VERSION><xsl:value-of select="$version" /></VERSION>
          <TAGCLASS><xsl:value-of select="../tagClass" /></TAGCLASS>
          <VALUENAME><xsl:value-of select="name" /></VALUENAME>
          <HTMLEXT>
            <xsl:variable name="ext" select="htmlExtend"/>
            <xsl:if test="$ext='true'"  >1</xsl:if>
            <xsl:if test="$ext='false'" >0</xsl:if>
          </HTMLEXT>
          <DESCRIPTION><xsl:value-of select="description" /></DESCRIPTION>
          <CONTENTS><xsl:value-of select="contents" /></CONTENTS>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
