/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;

public final class FileUtil {
    private static final NonClosePrintWriter outWriter = new NonClosePrintWriter(System.out);
    private static final NonClosePrintWriter errWriter = new NonClosePrintWriter(System.err);
    private static final String CR = System.getProperty("line.separator");
    private static final byte B_CR = 13;
    private static final byte B_LF = 10;

    private FileUtil() {
    }

    public static PrintWriter getPrintWriter(File file, String string) {
        return FileUtil.getPrintWriter(file, string, false);
    }

    public static PrintWriter getPrintWriter(File file, String string, boolean bl) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + unsupportedEncodingException.getMessage() + CR + "File=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + fileNotFoundException.getMessage() + CR + "File=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        return printWriter;
    }

    public static PrintWriter getLogWriter(String string) {
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001null \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        PrintWriter printWriter = "System.out".equalsIgnoreCase(string) ? outWriter : ("System.err".equalsIgnoreCase(string) ? errWriter : FileUtil.getPrintWriter(new File(string), "UTF-8", true));
        return printWriter;
    }

    public static PrintWriter getNonFlushPrintWriter(Writer writer) {
        return new NonFlushPrintWriter(writer);
    }

    public static BufferedReader getBufferedReader(File file, String string) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + unsupportedEncodingException.getMessage() + CR + "FIle=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + fileNotFoundException.getMessage() + CR + "FIle=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        return bufferedReader;
    }

    public static File checkFile(String string, String string2) {
        return FileUtil.checkFile(string, string2, 3);
    }

    public static File checkFile(String string, String string2, int n) {
        File file = null;
        for (int i = n; i > 0 && !(file = new File(string, string2)).exists(); --i) {
            if (i == 1) {
                return null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException");
            }
            System.out.println();
            System.out.print("CHECK File Error! CNT=" + i);
            System.out.print(" File=" + file.getAbsolutePath());
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u306e\u6b63\u5f0f\u30d1\u30b9\u540d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[" + file.getAbsolutePath() + "]";
            throw new RuntimeException(string3, iOException);
        }
    }

    public static void copy(String string, String string2) {
        FileUtil.copy(new File(string), new File(string2), false);
    }

    public static void copy(String string, String string2, boolean bl) {
        FileUtil.copy(new File(string), new File(string2), bl);
    }

    public static void copy(File file, File file2) {
        FileUtil.copy(file, file2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, boolean bl) {
        block16: {
            BufferedInputStream bufferedInputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            File file3 = file2;
            try {
                if (file2.isDirectory()) {
                    file3 = new File(file2, file.getName());
                }
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                int n = 8192;
                byte[] byArray = new byte[n];
                if (bl) {
                    int n2;
                    boolean bl2 = true;
                    int n3 = 0;
                    while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                        int n4 = 0;
                        if (bl2 && n2 >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                            n4 = 3;
                        } else if (n3 == 13 && byArray[0] == 10) {
                            n4 = 1;
                        }
                        bl2 = false;
                        for (int i = n4; i < n2; ++i) {
                            n3 = byArray[i];
                            if (n3 == 13 || n3 == 10) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                if (n3 != 13 || i + 1 >= n2 || byArray[i + 1] != 10) continue;
                                n3 = byArray[++i];
                                continue;
                            }
                            bufferedOutputStream.write(n3);
                        }
                    }
                    if (n3 != 13 && n3 != 10) {
                        bufferedOutputStream.write(13);
                        bufferedOutputStream.write(10);
                    }
                } else {
                    int n5;
                    while ((n5 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n5);
                    }
                }
                Closer.ioClose(bufferedInputStream);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                break block16;
            }
            finally {
                Closer.ioClose(bufferedInputStream);
                Closer.ioClose(bufferedOutputStream);
            }
            Closer.ioClose(bufferedOutputStream);
        }
    }

    public static void copyDirectry(String string, String string2) {
        FileUtil.copyDirectry(new File(string), new File(string2));
    }

    public static boolean copyDirectry(File file, File file2) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        boolean bl = true;
        if (!file2.exists() && !(bl = file2.mkdirs())) {
            System.err.println(file2.getName() + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray.length > i; ++i) {
            if (fileArray[i].isDirectory()) {
                FileUtil.copyDirectry(new File(file.toString(), fileArray[i].getName()), new File(file2.toString(), fileArray[i].getName()));
                continue;
            }
            FileUtil.copy(new File(file.toString(), fileArray[i].getName()), new File(file2.toString(), fileArray[i].getName()));
        }
        return true;
    }

    public static boolean deleteFiles(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    FileUtil.deleteFiles(fileArray[i]);
                }
            }
            if (!file.delete()) {
                return false;
            }
        }
        return true;
    }

    public static void getFileList(File file, boolean bl, List<String> list) {
        if (list == null) {
            return;
        }
        if (file.isFile()) {
            list.add(file.getAbsolutePath());
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.getFileList(fileArray[i], bl, list);
            }
        }
        if (bl) {
            Collections.sort(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Throwable {
        String string;
        if (stringArray.length != 4) {
            LogWriter.log("Usage: java FileUtil <file1> <encode1> <file2> <encode2>");
            return;
        }
        File file = new File(stringArray[0]);
        String string2 = stringArray[1];
        File file2 = new File(stringArray[2]);
        String string3 = stringArray[3];
        File file3 = new File(stringArray[2] + "_backup");
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, string2);
        PrintWriter printWriter = FileUtil.getPrintWriter(file3, string3);
        try {
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        finally {
            Closer.ioClose(bufferedReader);
            Closer.ioClose(printWriter);
        }
        if (!file2.delete()) {
            string = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]";
            throw new RuntimeException(string);
        }
        if (!file3.renameTo(file2)) {
            string = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file3 + "]";
            throw new RuntimeException(string);
        }
    }

    private static final class NonFlushPrintWriter
    extends PrintWriter {
        public NonFlushPrintWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    private static final class NonClosePrintWriter
    extends PrintWriter {
        public NonClosePrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() {
        }
    }
}

