/**************************************************************************/
/* GE36 ( バッチ送信エラーテーブル )                                      */
/*                                                                        */
/* Created : 2009/11/17 09:27:25                                          */
/**************************************************************************/
CREATE TABLE GE36 (
   PARA_KEY  VARCHAR2(9)                   NOT NULL      /* 10  パラメータキー   */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 20  システムID       */
 , ERRMSG    VARCHAR2(4000)                              /* 30  エラーメッセージ */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 800 ユニークキー     */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ       */
 , DYSET     VARCHAR2(14)                                /* 820 登録日時         */
 , USRSET    VARCHAR2(10)                                /* 850 作成社員         */
 , DYUPD     VARCHAR2(14)                                /* 860 更新日時         */
 , PGUPD     VARCHAR2(10)                                /* 870 更新PG           */
 , USRUPD    VARCHAR2(10)                                /* 890 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE36S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE36T01 
BEFORE INSERT ON GE36
FOR EACH ROW 
BEGIN 
SELECT GE36S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

