/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.business;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.business.BizLogic;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

abstract class AbstractBizLogic
implements BizLogic {
    private static final String CR = System.getProperty("line.separator");
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int NG = 2;
    protected static final int EXCEPTION = 8;
    protected static final int ORCL_ERR = 9;
    private Connection conn = null;
    private HybsLoader loader = null;
    private String[] keys = null;
    private String[] vals = null;
    private StringBuilder paramKeysStr = new StringBuilder("|");
    private Map<String, String> variableMap = new HashMap<String, String>();
    private Map<String, Formatter> formatMap = new HashMap<String, Formatter>();
    private Map<String, SystemParameter> sysParamMap = new HashMap<String, SystemParameter>();
    private ErrorMessage errMsg = new ErrorMessage();
    private String rtn = null;
    private boolean isDebug = false;
    private StringBuilder debugMsg = new StringBuilder();
    protected ArrayTableModel table = null;
    protected int row = -1;

    AbstractBizLogic() {
    }

    @Override
    public final void setConnection(Connection connection) {
        if (this.conn != null) {
            throw new RuntimeException("\u65e2\u306b\u63a5\u7d9a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.conn = connection;
    }

    @Override
    public final void setLoader(HybsLoader hybsLoader) {
        if (this.loader != null) {
            throw new RuntimeException("\u65e2\u306b\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u30fc\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.loader = hybsLoader;
    }

    @Override
    public final void setTable(ArrayTableModel arrayTableModel) {
        if (this.table != null) {
            throw new RuntimeException("\u65e2\u306b\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.table = arrayTableModel;
    }

    @Override
    public final void setKeys(String[] stringArray) {
        if (this.keys != null) {
            throw new RuntimeException("\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u30ad\u30fc)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.keys = stringArray;
    }

    @Override
    public final void setVals(String[] stringArray) {
        if (this.vals != null) {
            throw new RuntimeException("\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u5024)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.vals = stringArray;
    }

    @Override
    public final void setUserId(String string) {
        this.variableMap.put("CON.USERID", string);
    }

    @Override
    public final void setParentPgId(String string) {
        this.variableMap.put("CON.PGPID", string);
    }

    @Override
    public final void setDebug() {
        this.isDebug = true;
    }

    protected final boolean isDebug() {
        return this.isDebug;
    }

    @Override
    public final String getDebugMsg() {
        return this.debugMsg.toString();
    }

    protected final void debug(String string) {
        this.debugMsg.append(string).append(CR);
    }

    protected final String var(String string) {
        return this.variableMap.get(string);
    }

    protected final int vari(String string) {
        return this.var(string) == null ? 0 : Integer.valueOf(this.var(string));
    }

    protected final double vard(String string) {
        return this.var(string) == null ? 0.0 : Double.valueOf(this.var(string));
    }

    protected final void set(String string, String string2) {
        if (this.paramKeysStr.indexOf(string) >= 0) {
            throw new RuntimeException("\u5f15\u6570\u3068\u540c\u3058\u540d\u524d\u306e\u5909\u6570\u3092\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.variableMap.put(string, string2);
    }

    protected final String line(String string) {
        return this.line(string, this.row);
    }

    protected final String line(String string, int n) {
        if (this.table == null) {
            throw new RuntimeException("\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#line()\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        return n < 0 || n >= this.table.getRowCount() ? null : this.table.getValue(n, string);
    }

    protected final int linei(String string) {
        return this.line(string) == null ? 0 : Integer.valueOf(this.line(string));
    }

    protected final int linei(String string, int n) {
        return this.line(string, n) == null ? 0 : Integer.valueOf(this.line(string, n));
    }

    protected final double lined(String string) {
        return this.line(string) == null ? 0.0 : Double.valueOf(this.line(string));
    }

    protected final double lined(String string, int n) {
        return this.line(string, n) == null ? 0.0 : Double.valueOf(this.line(string, n));
    }

    @Override
    public final boolean exec() throws Throwable {
        this.makeParamMap();
        this.init();
        return this.main();
    }

    protected abstract void init();

    protected abstract boolean main();

    @Override
    public final int getKekka() {
        return this.errMsg.getKekka();
    }

    @Override
    public final ErrorMessage getErrMsg() {
        return this.errMsg;
    }

    @Override
    public final String getReturn() {
        return this.rtn;
    }

    protected final void rtn(String string) {
        this.rtn = string;
    }

    protected final boolean call(String string, String string2, String string3) {
        return this.call(string, string2, string3, this.row, this.table);
    }

    protected final boolean call(String string, String string2, String string3, int n, ArrayTableModel arrayTableModel) {
        ErrMsg[] errMsgArray;
        BizLogic bizLogic = (BizLogic)this.loader.newInstance(string);
        if (bizLogic.isRequireTable()) {
            throw new RuntimeException("\u3053\u306e\u30af\u30e9\u30b9\u306f\u3001\u5916\u90e8\u304b\u3089\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u30bb\u30c3\u30c8\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u305f\u3081\u3001\u5b50\u30ed\u30b8\u30c3\u30af\u3068\u3057\u3066\u547c\u3073\u51fa\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002[\u30af\u30e9\u30b9\u540d=" + bizLogic.getClass().getName() + "]");
        }
        bizLogic.setConnection(this.conn);
        bizLogic.setLoader(this.loader);
        bizLogic.setKeys(StringUtil.csv2Array(string2));
        bizLogic.setVals(StringUtil.csv2Array(this.replaceParam(string3, n, arrayTableModel)));
        bizLogic.setUserId(this.variableMap.get("CON.USERID"));
        bizLogic.setParentPgId(this.variableMap.get("CON.PGID"));
        if (this.isDebug) {
            bizLogic.setDebug();
        }
        boolean bl = false;
        try {
            bl = bizLogic.exec();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("\u5b50\u30ed\u30b8\u30c3\u30af\u306e\u547c\u3073\u51fa\u3057\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[logic=" + string + "]", throwable);
        }
        this.variableMap.put("RETURN", bizLogic.getReturn());
        if (this.isDebug) {
            this.debug(bizLogic.getDebugMsg());
        }
        if ((errMsgArray = bizLogic.getErrMsg().toArray()).length > 0) {
            ErrorMessage errorMessage = new ErrorMessage();
            for (int i = 0; i < errMsgArray.length; ++i) {
                errorMessage.addMessage(errMsgArray[i].copy(n));
            }
            this.errMsg.append(errorMessage);
        }
        return bl;
    }

    protected final void sql(String string) {
        this.sql(string, this.row, this.table);
    }

    protected final void sql(String string, int n, ArrayTableModel arrayTableModel) {
        ArrayTableModel arrayTableModel2 = this.execSQL(string, n, arrayTableModel);
        if (arrayTableModel2 != null && arrayTableModel2.getRowCount() > 0) {
            String[] stringArray = arrayTableModel2.getNames();
            String[] stringArray2 = arrayTableModel2.getValues(0);
            for (int i = 0; i < stringArray.length; ++i) {
                this.variableMap.put(stringArray[i], stringArray2[i]);
            }
        }
    }

    private ArrayTableModel execSQL(String string, int n, ArrayTableModel arrayTableModel) {
        ArrayTableModel arrayTableModel2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block9: {
            String string2 = string;
            string2 = this.replaceParam(string2, false);
            Formatter formatter = null;
            if (arrayTableModel != null && string2.indexOf(91) >= 0) {
                formatter = this.getFormatter(string2, arrayTableModel);
                string2 = formatter.getQueryFormatString();
            }
            preparedStatement = null;
            resultSet = null;
            arrayTableModel2 = null;
            try {
                preparedStatement = this.conn.prepareStatement(string2);
                if (arrayTableModel != null && formatter != null) {
                    int[] nArray = formatter.getClmNos();
                    for (int i = 0; i < nArray.length; ++i) {
                        preparedStatement.setObject(i + 1, arrayTableModel.getValue(n, nArray[i]));
                    }
                }
                boolean bl = preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (bl) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    String[] stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = resultSetMetaData.getColumnName(i + 1);
                    }
                    String[][] stringArray2 = DBUtil.resultToArray(resultSet, false);
                    arrayTableModel2 = new ArrayTableModel(stringArray, stringArray2);
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getFetchSize()));
                    break block9;
                }
                this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getUpdateCount()));
            }
            catch (SQLException sQLException) {
                try {
                    throw new RuntimeException("\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", sQLException);
                }
                catch (Throwable throwable) {
                    Closer.resultClose(resultSet);
                    Closer.stmtClose(preparedStatement);
                    throw throwable;
                }
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        return arrayTableModel2;
    }

    protected final void error(int n, String string, String ... stringArray) {
        this.error(this.row, n, string, stringArray);
    }

    protected final void error(int n, int n2, String string, String ... stringArray) {
        this.errMsg.addMessage(n, n2, string, this.replaceParam(stringArray));
    }

    protected final boolean must(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = true;
        String[] stringArray = StringUtil.csv2Array(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.variableMap.get(stringArray[i]);
            if (string2 != null && string2.length() != 0) continue;
            this.error(2, "ERR0012", "{#" + stringArray[i] + "}");
            bl = false;
        }
        return bl;
    }

    protected final boolean exist(String string, String string2, String string3, String string4) {
        return this.exist(string, string2, string3, string4, null, null);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6) {
        int n;
        String string7;
        String[] stringArray;
        if (string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
            throw new RuntimeException("\u30ab\u30e9\u30e0\u53c8\u306f\u3001\u5024\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        String string8 = string3 + (string5 == null || string5.length() == 0 ? "" : "," + string5);
        String[] stringArray2 = StringUtil.csv2Array(string8);
        if (stringArray2.length != (stringArray = StringUtil.csv2Array(string7 = string4 + (string6 == null || string6.length() == 0 ? "" : "," + string6))).length) {
            throw new RuntimeException("\u30ab\u30e9\u30e0\u3068\u5024\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select count(*) CNT from ").append(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            if (n == 0) {
                stringBuilder.append(" where ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(stringArray2[n]).append(" = ").append(stringArray[n]);
        }
        n = 0;
        ArrayTableModel arrayTableModel = this.execSQL(stringBuilder.toString(), this.row, this.table);
        if (arrayTableModel != null && arrayTableModel.getRowCount() >= 0) {
            n = Integer.valueOf(arrayTableModel.getValues(0)[0]);
        }
        String string9 = this.replaceParam(string4);
        if ("true".equalsIgnoreCase(string)) {
            if (n <= 0) {
                this.error(2, "ERR0025", "{#" + string3 + "}", string9);
                return false;
            }
        } else if ("false".equalsIgnoreCase(string)) {
            if (n > 0) {
                this.error(2, "ERR0026", "{#" + string3 + "}", string9);
                return false;
            }
        } else if ("one".equalsIgnoreCase(string)) {
            if (n > 1) {
                this.error(2, "ERR0027", "{#" + string3 + "}", string9);
                return false;
            }
        } else {
            throw new RuntimeException("type\u306f\u3001true\u3001false\u3001one\u306e\u3044\u305a\u308c\u304b\u3067\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
        }
        return true;
    }

    private void makeParamMap() {
        if (this.keys != null && this.vals != null) {
            if (this.keys.length == this.vals.length) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.paramKeysStr.append(this.keys[i]).append("|");
                    this.variableMap.put(this.keys[i], this.vals[i]);
                }
            } else {
                throw new RuntimeException("key\u3068val\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059");
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.JAPAN);
        String string = simpleDateFormat.format(new Date());
        this.variableMap.put("CON.YMDH", string);
        this.variableMap.put("CON.YMD", string.substring(0, 8));
        this.variableMap.put("CON.HMS", string.substring(8));
        this.variableMap.put("CON.PGID", this.getClass().getSimpleName());
    }

    private String replaceParam(String string) {
        return this.replaceParam(string, this.row, this.table);
    }

    private String replaceParam(String string, boolean bl) {
        return bl ? this.replaceParam(string, this.row, this.table) : this.replaceParam(string, 0, null);
    }

    private String replaceParam(String string, int n, ArrayTableModel arrayTableModel) {
        Object object;
        String string2 = string;
        if (this.variableMap.size() > 0 && string2.indexOf("{@") >= 0) {
            object = this.getSysParam(string2);
            string2 = ((SystemParameter)object).replace(this.variableMap);
        }
        if (arrayTableModel != null && string2.indexOf(91) >= 0) {
            object = this.getFormatter(string2, arrayTableModel);
            string2 = ((Formatter)object).getFormatString(n);
            string2 = ',' + string2 + ',';
            string2 = string2.replace(",null,", ",,");
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    private String[] replaceParam(String[] stringArray) {
        return this.replaceParam(stringArray, this.row, this.table);
    }

    private String[] replaceParam(String[] stringArray, int n, ArrayTableModel arrayTableModel) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.replaceParam(stringArray[i], n, arrayTableModel);
        }
        return stringArray;
    }

    private Formatter getFormatter(String string, ArrayTableModel arrayTableModel) {
        Formatter formatter = this.formatMap.get(string + arrayTableModel.toString());
        if (formatter == null) {
            formatter = new Formatter(arrayTableModel);
            formatter.setFormat(string);
            this.formatMap.put(string + arrayTableModel.toString(), formatter);
        }
        return formatter;
    }

    private SystemParameter getSysParam(String string) {
        SystemParameter systemParameter = this.sysParamMap.get(string);
        if (systemParameter == null) {
            systemParameter = new SystemParameter(string);
            this.sysParamMap.put(string, systemParameter);
        }
        return systemParameter;
    }

    protected final ArrayTableModel createTableBySql(String string) {
        return this.createTableBySql(string, this.row, this.table);
    }

    protected final ArrayTableModel createTableBySql(String string, int n, ArrayTableModel arrayTableModel) {
        return this.execSQL(string, n, arrayTableModel);
    }

    @Override
    public boolean isRequireTable() {
        return false;
    }
}

