/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.tomcat;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;

public class CacheDefaultServlet
extends DefaultServlet {
    private static final long serialVersionUID = 4353L;
    private String cacheControlHeader = null;

    public void init() throws ServletException {
        super.init();
        int maxage = 86400;
        if (this.getServletConfig().getInitParameter("maxage") != null) {
            maxage = Integer.parseInt(this.getServletConfig().getInitParameter("maxage"));
        }
        this.cacheControlHeader = "private, max-age=" + String.valueOf(maxage);
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            this.log("CacheDefaultServlet.serveResource:  " + path);
        }
        if (this.debug != 9 && (path.indexOf("/common/") >= 0 || path.indexOf("/menu/") >= 0 || path.indexOf("/image/") >= 0)) {
            response.setHeader("Cache-Control", this.cacheControlHeader);
            response.setHeader("Expires", null);
            response.setHeader("Pragma", null);
        }
        super.serveResource(request, response, content);
    }
}

