/**************************************************************************/
/* GF69 ( 不具合対策管理テーブル )                                        */
/*                                                                        */
/* Created : 2009/11/17 09:27:50                                          */
/**************************************************************************/
CREATE TABLE GF69 (
   PRJCODE     VARCHAR(30)                  NOT NULL                  /* 10  PRJコード    */
 , PHASE       VARCHAR(1)                   NOT NULL                  /* 20  実施フェーズ */
 , SEQNO       NUMERIC(7)       DEFAULT 0   NOT NULL                  /* 30  表示順       */
 , DYACC       VARCHAR(8)                                             /* 40  発生日       */
 , PRG_NAME    VARCHAR(120)                                           /* 50  処理名称     */
 , PGID        VARCHAR(30)                                            /* 60  PG-ID        */
 , SINSEI      VARCHAR(30)                                            /* 70  申請者       */
 , TRBL_CONT   BLOB                                                   /* 80  トラブル内容 */
 , ZANTEI      BLOB                                                   /* 90  暫定対策     */
 , CDIMP       VARCHAR(1)                                             /* 100 重要度       */
 , CDCONT      VARCHAR(1)                                             /* 110 要因         */
 , CASUS       BLOB                                                   /* 120 原因         */
 , BIKO        VARCHAR(2000)                                          /* 130 備考         */
 , RESOURCE_ID NUMERIC(9)                                             /* 140 リソースID   */
 , ACT_CONT    BLOB                                                   /* 150 対策内容     */
 , DYYOTE      VARCHAR(8)                                             /* 160 予定         */
 , DYKAN       VARCHAR(8)                                             /* 170 完成日       */
 , UNIQ        BIGINT                       NOT NULL PRIMARY KEY      /* 180 ユニークキー */
 , FGJ         VARCHAR(1)       DEFAULT '1' NOT NULL                  /* 190 状態フラグ   */
 , DYSET       VARCHAR(14)                                            /* 200 登録日時     */
 , PGSET       VARCHAR(10)                                            /* 210 作成PG       */
 , PGPSET      VARCHAR(10)                                            /* 220 作成親PG     */
 , USRSET      VARCHAR(10)                                            /* 230 作成社員     */
 , DYUPD       VARCHAR(14)                                            /* 240 更新日時     */
 , PGUPD       VARCHAR(10)                                            /* 250 更新PG       */
 , PGPUPD      VARCHAR(10)                                            /* 260 更新親PG     */
 , USRUPD      VARCHAR(10)                                            /* 270 更新者       */
);

CREATE SEQUENCE GF69S01 ;


CREATE TRIGGER GF69T01 FOR GF69
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF69S01,1 );
  END; 


