/**************************************************************************/
/* GF76 ( ファイル検索テーブル )                                          */
/*                                                                        */
/* Created : 2009/11/17 09:27:27                                          */
/**************************************************************************/
CREATE TABLE GF76 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS    VARCHAR2(256)                              /* 20  アドレス     */
 , PRE_FIX    VARCHAR2(10)                 NOT NULL      /* 20  名前空間     */
 , FILENAME   VARCHAR2(30)                               /* 30  ファイル名   */
 , FILEPATH   VARCHAR2(256)                              /* 40  ファイルパス */
 , MODIFIED   VARCHAR2(14)                               /* 50  最終更新日   */
 , TAGNAME    VARCHAR2(30)                               /* 60  タグ名称     */
 , TITLE      VARCHAR2(300)                              /* 70  タイトル     */
 , VERNO      VARCHAR2(10)                               /* 80  バージョン   */
 , MODIFYDATE VARCHAR2(30)                               /* 90  更新日       */
 , AUTHOR     VARCHAR2(100)                              /* 100 更新者       */
 , TEXTBODY   CLOB                                       /* 110 コメント文   */
 , FGOMIT     VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 120 除外フラグ   */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET      VARCHAR2(14)                               /* 820 登録日時     */
 , PGSET      VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET     VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET     VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD      VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD      VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD     VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD     VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 512K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF76S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF76T01 
BEFORE INSERT ON GF76
FOR EACH ROW 
BEGIN 
SELECT GF76S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

