<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
<!--
  <xsl:param name="DYSET"	  select='java:org.opengion.fukurou.tools.util.DateSet.getDate( "yyyyMMddHHmmss" )' />
-->

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root" >
	<xsl:apply-templates select="//og:view" />
  </xsl:template>

  <xsl:template match="og:view" >
	 <xsl:if test="not(@useScrollBar) and (ancestor::table | ancestor::div)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21A</MSGCD>
		 <MSGTXT >og:view タグを、table , div などで囲うとヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT	 ><xsl:copy-of select="." /></TEXT>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and ((following::og:link) | (following::og:column))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21B</MSGCD>
		 <MSGTXT >og:view タグの後ろに、og:link や og:column タグがあると、ヘッダー固定時に見えなくなります。</MSGTXT>
		 <TEXT	 ><xsl:copy-of select="." /></TEXT>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (last() &gt; 1) and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21C</MSGCD>
		 <MSGTXT >og:view タグが複数存在すると、ヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT	 ><xsl:copy-of select="." /></TEXT>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useScrollBar='true'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21D</MSGCD>
		 <MSGTXT >og:view のヘッダー固定は、推奨機能なので、個別に設定しないでください。</MSGTXT>
		 <TEXT	 ><xsl:copy-of select="." /></TEXT>
	   </ROW>
	 </xsl:if>
  </xsl:template>

</xsl:stylesheet>
