<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2040"
	title	= "インデックスカラム"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "SYSTEM_ID"
/>

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select TABLE_NAME,INDEX_NAME,COLUMN_NAME AS CLM,COLUMN_POSITION AS SEQNO,
			'{@SYSTEM_ID}' AS SYSTEM_ID,'{@TBLSYU}' AS TBLSYU
		from USER_IND_COLUMNS
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_IND_COLUMNS.TABLE_NAME
					)
		and   INSTR(TABLE_NAME,'$') &lt; 1
		and   INSTR(INDEX_NAME,'$') &lt; 1
		and   INSTR(COLUMN_NAME,'$') &lt; 1
	</jsp:text>
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
		</og:where>
	<jsp:text>
		order by TABLE_NAME,INDEX_NAME,COLUMN_POSITION
	</jsp:text>
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "NEW"
	columnWritable   = "SEQNO"
	checked    = "true"
	startNo    = "{@startNo}"
	pageSize   = "10000" />

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GF07
		(TABLE_NAME,INDEX_NAME,CLM,SEQNO,SYSTEM_ID,TBLSYU,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([TABLE_NAME],[INDEX_NAME],[CLM],[SEQNO],[SYSTEM_ID],[TBLSYU],
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
  </jsp:text>
</og:hidden>

<og:hidden name="SQL2" >
  <jsp:text>
	DELETE FROM GF07
	WHERE SYSTEM_ID = [SYSTEM_ID] AND TABLE_NAME = [TABLE_NAME] AND TBLSYU = [TBLSYU]
  </jsp:text>
</og:hidden>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
