<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page errorPage="/jsp/common/error.jsp" />

<og:head headType="menu" >
	<script type="text/javascript" src="GmisTree.js" ><!-- --></script>
	<script type="text/javascript" src="logout.js" ><!-- --></script>
</og:head>

<!-- ボタン時の場合のみこのJavaScriptを実行する -->
<og:equals val1="{@buttonRequest}" val2="true">
	<!-- ボタン時のロールオーバー効果 -->
	<script type="text/javascript">//<![CDATA[
			function buttonOver( obj ){
				if( obj.selected != 1 ){
					obj.style.backgroundImage = 'url("../image/button_gra3.png")';
				}
			}
			
			function buttonOut( obj ){
				if( obj.selected != 1 ){
					obj.style.backgroundImage = 'url("../image/button_gra1.png")';
				}
			}
			
			function buttonClick( obj ){
				//ボタン全てに対してbackgroundを戻す処理を行うので注意。
				var buttons = document.getElementsByTagName("button");
				for( var i = 0; i < buttons.length; i++){
					buttons[i].style.backgroundImage = 'url("../image/button_gra1.png")';
					buttons[i].selected = 0;
				}
				obj.selected = 1;
				obj.style.backgroundImage = 'url("../image/button_gra2.png")';
			}
			
			function onLoadChange( gamenId ){
				var selected_button = document.getElementById(gamenId);
				if( selected_button != null){
					selected_button.selected = 1;
					selected_button.style.backgroundImage = 'url("../image/button_gra2.png")';
				}
			}
			
	//]]>
		
	function onLoadChange2(){
		<og:text>
		onLoadChange( "{@GAMENID}" );
		</og:text>
	}
	addEvent(window,"load", onLoadChange2);
	addEvent(window,"unload", ie_X);
	</script>
</og:equals>

<style type="text/css">
	.MENU_G {
		border:1px solid #9933ff; 
		font-weight:bold; 
		vertical-align:middle ; 
		text-align:center;
	}

	.MENU_G a:hover img { filter:xray(); }
</style>

<body>
<jsp:directive.include file="/jsp/custom/menu_init.jsp" />

<og:equals val1="{@buttonRequest}" nullCheck="true" >
	<!-- ボタンメニュー以外ではMatrixMenuを表示する -->
	<div style="text-align:center">
		<a href="matrixMenu.jsp?cache=false" target="_top">MatrixMenu</a>
	</div>

	<!-- ボタンメニュー時はグループを出さない -->
	<strong class="borderBotton">
	<table summary="GroupMenu">
		<og:topMenu
			menuType	= "GROUP" 
			href		= "multiMenu.jsp" 
			target		= "MENU" 
			imageOnly	= "true"
			sideCount	= "7"
			cache		= "{@cache}"
			match		= "{@match}"
			unmatch		= "{@unmatch}"

		/>
	</table>
	</strong>
</og:equals>

<!-- ボタンリクエストがある場合はinlineStyleをtrueにする -->
<og:equals val1="{@buttonRequest}" nullCheck="true" notEquals="true" >
	<og:value key="inlineStyle" value="true" />
</og:equals>

<strong style="white-space:nowrap;" >
	<og:topMenu
		menuType	= "NORMAL" 
		groups		= "{@group}"
		expand		= "{@expand}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
		useButton	= "{@buttonRequest}"
		useButtonScript="{@buttonRequest}"
		classify	= "{@classify}"
		inlineStyle = "{@inlineStyle}"
	/>
</strong>

<jsp:directive.include file="/jsp/custom/menu_end.jsp" />
</body>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
