/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * カレンダー表示クラスで使用する各種キーパラメータを管理している定数クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public final static で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.group その他
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class ViewCalendarParam  {

	// 3.5.6.0 (2004/06/18) taglib/ViewCalendarParamTag 用のキー
	public final static String VIEW_KEYS		 = "h_viewKeys"		 ;
	public final static String YM_KEY			 = "h_ymKey"			 ;
	public final static String DAY_KEY			 = "h_dayKey"		 ;
	public final static String VALUE_KEY		 = "h_valueKey"		 ;
	public final static String VALUE_BR_FLAG_KEY = "h_valueBRFlagKey" ;
	public final static String FIRSTWEEK_KEY	 = "h_firstWeek"		 ;
	public final static String HEADER_LOCALE_KEY = "h_headerLocale"	 ;
	public final static String COLUMN_SIZE_KEY	 = "h_columnSize"	 ;

	// 3.5.6.0 (2004/06/18) taglib/ViewCalendarParamTag 用の初期値
	public final static String VIEW_VALUES			= "CDJGS"	;
	public final static String YM_VALUE				= "YYYYMM"	;
	public final static String DAY_VALUE			= "DY"		;
	public final static String VALUE_BR_FLAG_VALUE	= "true"	;
	public final static String FIRSTWEEK_VALUE		= "0"		;
	public final static String HEADER_LOCALE_VALUE	= "en"		;
	public final static String COLUMN_SIZE_VALUE	= "3"		;
}
