/**************************************************************************/
/* GEA05 ( ロールマスタ )                                                 */
/*                                                                        */
/* Created : 2009/12/10 12:29:42                                          */
/**************************************************************************/
CREATE TABLE GEA05 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ROLES     VARCHAR2(500)                NOT NULL      /* 20  ロールズ     */
 , NMROLE    VARCHAR2(200)                              /* 30  ロール名称   */
 , KBROLE    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 40  ロール区分   */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 820 登録日時     */
 , USRSET    VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 870 更新PG       */
 , USRUPD    VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA05S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA05T01 
BEFORE INSERT ON GEA05
FOR EACH ROW 
BEGIN 
SELECT GEA05S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

