/**************************************************************************/
/* GF06 ( インデックス定義 )                                              */
/*                                                                        */
/* Created : 2009/12/16 19:47:04                                          */
/**************************************************************************/
CREATE TABLE GF06 (
   SYSTEM_ID       VARCHAR(10)                  NOT NULL                  /* 10  システムID               */
 , TBLSYU          VARCHAR(1)                   NOT NULL                  /* 20  テーブル種別             */
 , TABLE_NAME      VARCHAR(50)                  NOT NULL                  /* 30  テーブル名               */
 , INDEX_NAME      VARCHAR(30)                  NOT NULL                  /* 40  インデックス名           */
 , NAME_JA         VARCHAR(200)                                           /* 50  名称                     */
 , INDTYPE         VARCHAR(1)                   NOT NULL                  /* 60  インデックスタイプ       */
 , TABLESPACE_NAME VARCHAR(30)                  NOT NULL                  /* 70  テーブルスペース名       */
 , INITIAL_AUTO    NUMERIC(10)      DEFAULT 0   NOT NULL                  /* 80  自動計算初期エクステント */
 , INITIAL_EXTENT  NUMERIC(10)      DEFAULT 16  NOT NULL                  /* 90  初期エクステント(KB)     */
 , NEXT_EXTENT     NUMERIC(10)      DEFAULT 16  NOT NULL                  /* 100 ＮＥＸＴエクステント     */
 , BIKO            VARCHAR(2000)                                          /* 180 備考                     */
 , UNIQ            BIGINT                       NOT NULL PRIMARY KEY      /* 800 ユニークキー             */
 , FGJ             VARCHAR(1)       DEFAULT '1' NOT NULL                  /* 810 状態フラグ               */
 , DYSET           VARCHAR(14)                                            /* 820 登録日時                 */
 , PGSET           VARCHAR(10)                                            /* 830 作成PG                   */
 , PGPSET          VARCHAR(10)                                            /* 840 作成親PG                 */
 , USRSET          VARCHAR(10)                                            /* 850 作成社員                 */
 , DYUPD           VARCHAR(14)                                            /* 860 更新日時                 */
 , PGUPD           VARCHAR(10)                                            /* 870 更新PG                   */
 , PGPUPD          VARCHAR(10)                                            /* 880 更新親PG                 */
 , USRUPD          VARCHAR(10)                                            /* 890 更新者                   */
);

CREATE SEQUENCE GF06S01 ;


CREATE TRIGGER GF06T01 FOR GF06
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF06S01,1 );
  END; 


