<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT07"
	title	= "リソース進捗チャート"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "VIEW_DATE"
/>

<og:value command="SQL">
	<jsp:text>
		select NVL(MAX(TO_CHAR((TO_DATE(A.DYSTART)+A.DURATION),'YYYYMMDD')),'{@VIEW_DATE}') AS DYMAX
		from GF64 A,GF66 B
		where A.FGJ  in  ('0','1')
		and   B.FGJ  in  ('0','1')
		and   A.PRJCODE = B.PRJCODE
		and   A.TASK_ID = B.TASK_ID
		and   DYDIFF(A.DYSTART,'{@VIEW_DATE}',A.DURATION) &gt; 0
	</jsp:text>
	<og:where startKey="and" >
		<og:and value = "WARN(A.DYSTART,A.DURATION,A.COMPLETE) &gt;= '{@WARN}'" />
		<og:and value = "B.RESOURCE_ID = '{@RESOURCE_ID}'" />
		<og:and value = "A.TASK_LEVEL  = '{@TASK_LEVEL}'"  />
		<og:and value = "A.COMPLETE {@COMPLETE}"           />
	</og:where>
</og:value>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.PRJCODE,PRJ_NAME(A.PRJCODE) AS PRJ_NAME,B.RESOURCE_ID,A.TASK_ID,A.SEQ,A.NAME_JA AS TASK_NAME,A.MEETING,A.DYSTART,A.DURATION,A.COMPLETE,A.PRIORITY,
				VIEW_ZOOM(DYDIFF(A.DYSTART,'{@VIEW_DATE}'),'{@VIEW_ZOOM}') AS DYSTR,
				TO_CHAR(TO_DATE(A.DYSTART,'YYYYMMDD')+A.DURATION-1,'YYYYMMDD') AS DYEND,
				VIEW_ZOOM(((A.DURATION-DYDIFF('{@VIEW_DATE}',A.DYSTART)) * A.COMPLETE / 100.0 ),'{@VIEW_ZOOM}') AS SUMI,
				VIEW_ZOOM(((A.DURATION-DYDIFF('{@VIEW_DATE}',A.DYSTART)) * ( 1.0 - A.COMPLETE / 100.0 )),'{@VIEW_ZOOM}') AS MADA,
				A.MEETING || (CASE A.COMPLETE WHEN 100 THEN 1 ELSE 0 END) AS MCOMP,
				WARN(A.DYSTART,A.DURATION,A.COMPLETE) AS WARN,
				GET_RESOURCE(A.PRJCODE,A.TASK_ID) AS RESOURCE_NAMES
		from GF64 A,GF66 B
		where A.FGJ  in  ('0','1')
		and   B.FGJ  in  ('0','1')
		and   A.PRJCODE = B.PRJCODE
		and   A.TASK_ID = B.TASK_ID
		and   DYDIFF(A.DYSTART,'{@VIEW_DATE}',A.DURATION) &gt; 0
	</jsp:text>
	<og:where startKey="and" >
		<og:and value = "WARN(A.DYSTART,A.DURATION,A.COMPLETE) &gt;= '{@WARN}'" />
		<og:and value = "B.RESOURCE_ID = '{@RESOURCE_ID}'" />
		<og:and value = "A.TASK_LEVEL  = '{@TASK_LEVEL}'"  />
		<og:and value = "A.COMPLETE {@COMPLETE}"           />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "A.DYSTART,A.DURATION" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="PRJ_NAME" gamenId="GANTT06" href="index.jsp" target="CONTENTS"
		keys="command,PRJCODE,VIEW_DATE,VIEW_DATE2,VIEW_ZOOM,VIEW_ZOOM2"
		vals="NEW,[PRJCODE],[DYSTART],[DYSTART],{@VIEW_ZOOM},{@VIEW_ZOOM}" />
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	rowspan    = "1"
	headerSkipCount = "0"
>
	<jsp:directive.include file="view.jsp" />
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
