<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2030"
	title	= "インデックス"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "SYSTEM_ID"
/>

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select INDEX_NAME,TABLE_NAME,TABLESPACE_NAME,INDEX_NAME AS NAME_JA,
				(CASE UNIQUENESS WHEN 'UNIQUE' THEN '1' ELSE '2' END) AS INDTYPE,
				'0' AS INITIAL_AUTO,
				INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				NEXT_EXTENT/1024 AS NEXT_EXTENT,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_INDEXES
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_INDEXES.TABLE_NAME
					)
		and   INSTR(TABLE_NAME,'$') &lt; 1
		and   INSTR(INDEX_NAME,'$') &lt; 1
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'"  />
	</og:where>
	<jsp:text>
		order by TABLE_NAME,INDEX_NAME
	</jsp:text>
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "NEW"
	columnWritable   = "NAME_JA,INITIAL_EXTENT"
	checked    = "true"
	startNo    = "{@startNo}"
	pageSize   = "10000" />

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GF06
		(SYSTEM_ID,TBLSYU,TABLE_NAME,INDEX_NAME,NAME_JA,INDTYPE,TABLESPACE_NAME,
		 INITIAL_EXTENT,INITIAL_AUTO,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([SYSTEM_ID],[TBLSYU],[TABLE_NAME],[INDEX_NAME],[NAME_JA],[INDTYPE],[TABLESPACE_NAME],
		 [INITIAL_EXTENT],16,
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
  </jsp:text>
</og:hidden>

<og:hidden name="SQL2" >
  <jsp:text>
	DELETE FROM GF06 WHERE SYSTEM_ID = [SYSTEM_ID] AND TABLE_NAME = [TABLE_NAME] AND TBLSYU = [TBLSYU]
  </jsp:text>
</og:hidden>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
