/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.business;

/**
 * カーソル定義による配列型テーブルモデルをメインカーソルとした業務ロジックの構造を定義します。
 * 
 * 配列型テーブルモデルについては、cursor()メソッドを実装により定義します。
 * cursor()メソッドを実装し、この戻り値をSQL文として実行し、その結果セットから配列型
 * テーブルモデルを生成し、これをメインカーソルとして使用します。
 * 配列型テーブルモデルが定義されていない場合、エラーとなります。
 * 
 * このクラスでは、以下に示すメソッドが呼び出されるタイミングのみを定義しています。
 * メソッドの中身については、{@link BizLogic_TABLE}を参照して下さい。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class BizLogic_CURSOR extends BizLogic_TABLE {

	/**
	 * 配列型テーブルモデルを生成するためのSQL文を定義します。
	 * このメソッドからSQL文から返された場合、この結果セットから配列型テーブルモデルを生成し、
	 * メインカーソルとして使用します。
	 * 
	 * @return 配列型テーブルモデルを生成するためのSQL文
	 */
	protected String cursor() {
		return null;
	}

	/**
	 * 処理のメインロジックの前処理を記述します。
	 */
	protected void init() {
		if( cursor() == null ) {
			throw new RuntimeException( "カーソルが定義されていません" );
		}
		table = createTableBySql( cursor() );
	}

	/**
	 * このクラスは、テーブルモデルが外部から指定されている必要はありません。
	 * 
	 * @see BizLogic#isRequireTable()
	 * @return false
	 */
	public boolean isRequireTable() {
		return false;
	}
}