/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.db;

import java.util.Locale;

/**
 * 各データベースにおける関数名の差異を吸収するためのクラスです。
 * 全てのメソッドは、static メソッドになっています。
 *
 * @og.rev 4.3.7.0 (2009/06/01) 新規作成
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public final class DBFunctionName {

	/**
	 * インスタンスを作らないので、コンストラクタは、private に設定します。
	 */
	private DBFunctionName() {}

	/**
	 * 各データベースに対応するファンクション名を返します。
	 * 
	 * @og.rev 4.3.8.0 (2009/08/01) SUBSTRを追加
	 * @og.rev 5.1.2.0 (2010/01/01) MySQL対応,SUBSTRB廃止(帳票データの分割の内部処理化に伴う)
	 *
	 * @param   func ファンクション名(定義文字)
	 * @param   dbName データベース名
	 * @return  実ファンクション名
	 */
	public static String getFunctionName( final String func ,final String dbName ) {
		String dbn = dbName.toUpperCase( Locale.JAPAN );
		String rtn = func;

		if( dbn.indexOf( "ORACLE" ) >= 0
			|| dbn.indexOf( "HSQL" ) >= 0
			|| dbn.indexOf( "MYSQL" ) >= 0
			|| dbn.indexOf( "POSTGRES" ) >= 0 ) {
			if( "CON".equals( func ) 		) { rtn = "||"; }
			if( "SUBSTR".equals( func ) 	) { rtn = "SUBSTR"; }
//			if( "SUBSTRB".equals( func ) 	) { rtn = "SUBSTRB"; }
		}
		else if( dbn.indexOf( "SQLSERVER" ) >= 0 ) { //?
			if( "CON".equals( func ) 		) { rtn = "+"; }
			if( "SUBSTR".equals( func ) 	) { rtn = "SUBSTRING"; }
		}
		else {
			if( "CON".equals( func ) 		) { rtn = "||"; }
			if( "SUBSTR".equals( func ) 	) { rtn = "SUBSTR"; }
		}
		return rtn;
	}
}
