/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.process.ConnData;
import org.opengion.fukurou.util.Closer;

public final class ConnDataFactory {
    private static final long MAX_ALIVE_TIME = 1800000L;
    private static final int MAX_LIST_COUNT = 3;
    private static final Map<Integer, List<ConnData>> connMap = new HashMap<Integer, List<ConnData>>();
    private static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String CR = System.getProperty("line.separator");

    private ConnDataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnData createConnData(String string, String string2, String string3) {
        int n = (string + "," + string2 + "," + string3).hashCode();
        ConnData connData = null;
        Map<Integer, List<ConnData>> map = connMap;
        synchronized (map) {
            List<ConnData> list = connMap.get(n);
            if (list != null && !list.isEmpty()) {
                int n2 = list.size() - 1;
                connData = list.remove(n2);
            }
        }
        if (connData == null) {
            connData = new ConnData(string, string2, string3, n);
        }
        return connData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeConnData(ConnData connData, boolean bl) {
        if (connData != null) {
            Connection connection = connData.getConnection();
            if (bl) {
                Closer.commit(connection);
                if (connData.getCreateTime() + 1800000L > System.currentTimeMillis()) {
                    int n = connData.getUniq();
                    Map<Integer, List<ConnData>> map = connMap;
                    synchronized (map) {
                        List<ConnData> list = connMap.get(n);
                        if (list == null) {
                            list = new ArrayList<ConnData>();
                        }
                        if (list.size() >= 3) {
                            Closer.connClose(connection);
                        } else {
                            list.add(connData);
                            connMap.put(n, list);
                        }
                    }
                } else {
                    Closer.connClose(connection);
                }
            } else {
                Closer.rollback(connection);
                Closer.connClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Integer, List<ConnData>> map = connMap;
        synchronized (map) {
            for (List<ConnData> list : connMap.values()) {
                for (ConnData connData : list) {
                    Connection connection = connData.getConnection();
                    Closer.connClose(connection);
                }
                list.clear();
            }
            connMap.clear();
        }
    }

    static {
        try {
            Class.forName(ORACLE_DRIVER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[oracle.jdbc.OracleDriver]";
            throw new RuntimeException(string, classNotFoundException);
        }
    }
}

