/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import java.util.List;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_XML
extends TableWriter_Default {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private String firstExecSql = "";
    private String lastExecSql = "";
    private String tableName = "";

    @Override
    public void writeDBTable(PrintWriter printWriter) {
        super.setHeaderSequence("D");
        super.writeDBTable(printWriter);
    }

    @Override
    protected void writeHeader(PrintWriter printWriter) {
        String string = this.getEncode();
        printWriter.println("<?xml version='1.0' encoding='" + string + "'?>");
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        printWriter.print("<ROWSET");
        printWriter.print(this.tableName);
        printWriter.println(">");
        printWriter.println(this.firstExecSql);
        for (int i = 0; i < n; ++i) {
            printWriter.print("<ROW num=\"");
            printWriter.print(i + 1);
            printWriter.println("\">");
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n2 = this.clmNo[j];
                String string = (String)dBTableModel.getValue(i, n2);
                if ("NVAR".equals(this.dbColumn[n2].getDbType())) {
                    string = StringUtil.getReplaceEscape((String)string);
                }
                printWriter.print("<");
                printWriter.print(dBTableModel.getColumnName(n2));
                printWriter.print(">");
                printWriter.print(StringUtil.htmlFilter((String)string));
                printWriter.print("</");
                printWriter.print(dBTableModel.getColumnName(n2));
                printWriter.println(">");
            }
            printWriter.println("</ROW>");
        }
        printWriter.println(this.lastExecSql);
        printWriter.println("</ROWSET>");
    }

    @Override
    public void setParam(List<HybsEntry> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            HybsEntry[] hybsEntryArray = list.toArray(new HybsEntry[list.size()]);
            for (int i = 0; i < hybsEntryArray.length; ++i) {
                String string = hybsEntryArray[i].getKey();
                String string2 = hybsEntryArray[i].getValue();
                if ("First".equalsIgnoreCase(string)) {
                    stringBuilder.append("<EXEC_SQL>");
                    stringBuilder.append(StringUtil.htmlFilter((String)string2));
                    stringBuilder.append("</EXEC_SQL>");
                    stringBuilder.append(HybsSystem.CR);
                    continue;
                }
                if ("Last".equalsIgnoreCase(string)) {
                    stringBuilder2.append("<EXEC_SQL>");
                    stringBuilder2.append(StringUtil.htmlFilter((String)string2));
                    stringBuilder2.append("</EXEC_SQL>");
                    stringBuilder2.append(HybsSystem.CR);
                    continue;
                }
                if (!"TableName".equalsIgnoreCase(string) || string2 == null || string2.length() <= 0) continue;
                this.tableName = " tableName=\"" + string2 + "\"";
            }
            this.firstExecSql = stringBuilder.toString();
            this.lastExecSql = stringBuilder2.toString();
        }
    }
}

