<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0017"
	title    = "ロールマスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,ROLES,NMROLE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select '1' as WRITABLE,ROLES,NMROLE,KBROLE,SYSTEM_ID,FGJ,UNIQ
		from GEA05
	</jsp:text>
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "ROLES		like '{@ROLES}%'"	/>
		<og:and value = "NMROLE	like '{@NMROLE}%'"	/>
		<og:and value = "KBROLE	=	 '{@KBROLE}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,KBROLE,ROLES" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,ROLES,KBROLE" must="true" />

<og:viewLink command="{@command}">
	<og:link column="ROLES" gamenId="GE0019" href="index.jsp" target="CONTENTS" onLink="[KBROLE]" markList="1"
		keys="command,SYSTEM_ID,ROLES,KBROLE"
		vals="NEW,[SYSTEM_ID],[ROLES],1" />
	<og:link column="ROLES" gamenId="GE0019" href="index.jsp" target="CONTENTS" onLink="[KBROLE]" markList="2"
		keys="command,SYSTEM_ID,ROLES,KBROLE"
		vals="NEW,[SYSTEM_ID],[ROLES],2" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,ROLES,KBROLE"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GEA05" /></strong></legend>
		<og:column  name="SYSTEM_ID" useRequestValue="false" must="true" td="no" />
		<og:submit  value="update" lbl="COPY" command="COPY"
			keys="noWritable,sysins" vals="null,true" />
	</fieldset>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
