<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2090"
	title	= "テーブル差分"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@choice}" val2="sabun">
	<og:forward page="sabun.jsp" keys="command" vals="RENEW" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID1,SYSTEM_ID2,TABLE_NAME1,TABLE_NAME2"
	nullCheck = "TABLE_NAME,SYSTEM_ID1,SYSTEM_ID2,ACTION,compareKeys"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:value command="SET" key="c_keys" value="{@compareKeys}" action="APPEND" />
<og:value command="SET" key="d_keys" value="{@diffKeys}"    action="APPEND" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="100000">
	<jsp:text>
		select *
		from {@TABLE_NAME}
	</jsp:text>
	<og:where>
		<og:and value="SYSTEM_ID	= '{@SYSTEM_ID1}'" />
		<og:and value="TBLSYU		= '{@TBLSYU1}'" />
		<og:and value="'1'			= '{@USED_1}'" />
		<og:and value="TABLE_NAME	like '{@TABLE_NAME1}%'" />
		<og:and value="FGJ			in  ('0','1')" />
	</og:where>
	<jsp:text>
		<og:equals val1="{@TABLE_NAME}" val2="GF02">
			order by SYSTEM_ID,TBLSYU,TABLE_NAME
		</og:equals>
		<og:equals val1="{@TABLE_NAME}" val2="GF05">
			order by SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO
		</og:equals>
		<og:equals val1="{@TABLE_NAME}" val2="GF06">
			order by SYSTEM_ID,TBLSYU,TABLE_NAME,INDEX_NAME
		</og:equals>
		<og:equals val1="{@TABLE_NAME}" val2="GF07">
			order by SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO
		</og:equals>
		<og:equals val1="{@TABLE_NAME}" val2="GF82">
			order by SYSTEM_ID,TBLSYU,OBJ_NAME
		</og:equals>
	</jsp:text>
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="100000" scope="request">
	<jsp:text>
		select *
		from {@TABLE_NAME}
	</jsp:text>
	<og:where>
		<og:and value="SYSTEM_ID	= '{@SYSTEM_ID2}'" />
		<og:and value="TBLSYU		= '{@TBLSYU2}'" />
		<og:and value="'1'			= '{@USED_2}'" />
		<og:and value="TABLE_NAME	like  '{@TABLE_NAME2}%'" />
		<og:and value="FGJ			in  ('0','1')" />
	</og:where>
</og:query>

<og:tableMerge
	command		= "{@command}"
	action		= "{@ACTION}"
	scope		= "session"
	masterScope	= "session"
	slaveScope	= "request"
	masterKeys	= "{@c_keys}"
	diffKeys	= "{@d_keys}"
	display		= "true"
/>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
	<og:hidden name="TABLE_NAME" value="{@TABLE_NAME}" />
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ,UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
