<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.TBLSYU,A.TABLE_NAME,
				B.YOYAKU,
					CASE B.DBNAME
						WHEN 'ORACLE'     THEN 'ORA'
						WHEN 'SQLSERVER'  THEN 'MS'
						WHEN 'SQL2008'    THEN '08'
						WHEN 'SQL2003'    THEN '03'
						WHEN 'SQL92'      THEN '92'
						WHEN 'SQL99'      THEN '99'
						WHEN 'MYSQL'      THEN 'MY'
						WHEN 'SQLITE'     THEN 'SQL'
						WHEN 'POSTGRESQL' THEN 'POS'
						WHEN 'FIREBIRD'   THEN 'FB'
						ELSE 'OTR'
			 		END AS DBNAME,
			B.CDYOYAKU
		from GF05 A, GF19 B
		where A.CLM = B.YOYAKU
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.FGJ			in  ('0','1')"		/>
		<og:and value = "A.SYSTEM_ID	=  '{@SYSTEM_ID}'"	/>
		<og:and value = "A.TBLSYU		=  '{@TBLSYU}'"		/>
		<og:and value = "B.CDYOYAKU		=  '{@CDYOYAKU}'"	/>
	</og:where>
	<jsp:text>
		order by A.SYSTEM_ID,A.TBLSYU,A.TABLE_NAME,A.SEQNO
	</jsp:text>
</og:query>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLCrossTable"
	command		= "{@command}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
	useParam	= "true"
  >
	<og:crossParam
		cubeXColumn	= "YOYAKU"
		cubeYColumn	= "DBNAME"
	/>
</og:view>
