/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

/**
 * Native Type(int型やlong型等)を管理するEnum型です。
 * 
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public enum NativeType {

	/** NATIVEの型 [int] の識別コード (INT)  */
	INT
	
	/** NATIVEの型 [long] の識別コード (LONG)  */
	,LONG
	
	/** NATIVEの型 [double] の識別コード (DOUBLE)  */
	,DOUBLE
	
	/** NATIVEの型 [String] の識別コード (STRING)  */
	,STRING
	
	/** NATIVEの型 [Calendar] の識別コード (CALENDAR)  */
	,CALENDAR
}
