/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import java.util.List;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableWriter;

public class TableWriter_Default
implements TableWriter {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private String separator = "\t";
    private String headerSequence = HybsSystem.sys((String)"WRITER_HEADER_SEQUENCE");
    protected int numberOfColumns = -1;
    private boolean append = false;
    protected DBTableModel table = null;
    protected DBColumn[] dbColumn = null;
    protected int[] clmNo = null;
    private String lang = null;
    protected int[] dbType = null;
    public static final int STRING = 0;
    public static final int NVAR = 1;
    public static final int NUMBER = 2;
    private String columns = null;
    private String encode = null;
    private boolean useNumber = true;

    public void writeDBTable() {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void writeDBTable(PrintWriter printWriter) {
        if (!this.createDBColumn()) {
            return;
        }
        this.writeHeader(printWriter);
        block8: for (int i = 0; i < this.headerSequence.length(); ++i) {
            switch (this.headerSequence.charAt(i)) {
                case 'N': {
                    this.writeName(this.table, printWriter);
                    continue block8;
                }
                case 'L': {
                    this.writeLabel(this.table, printWriter);
                    continue block8;
                }
                case 'S': {
                    this.writeSize(this.table, printWriter);
                    continue block8;
                }
                case 'C': {
                    this.writeClass(this.table, printWriter);
                    continue block8;
                }
                case '-': {
                    this.writeSeparator(this.table, printWriter);
                    continue block8;
                }
                case 'D': {
                    this.writeData(this.table, printWriter);
                    continue block8;
                }
            }
        }
    }

    protected boolean createDBColumn() {
        boolean bl = false;
        if (this.lang != null && this.table != null) {
            if (this.columns != null) {
                String[] stringArray = StringUtil.csv2Array((String)this.columns);
                this.numberOfColumns = stringArray.length;
                this.clmNo = new int[this.numberOfColumns];
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    int n;
                    this.clmNo[i] = n = this.table.getColumnNo(stringArray[i]);
                }
            } else {
                this.numberOfColumns = this.table.getColumnCount();
                this.clmNo = new int[this.numberOfColumns];
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    this.clmNo[i] = i;
                }
            }
            this.dbColumn = this.table.getDBColumns();
            bl = this.numberOfColumns > 0;
            this.dbType = new int[this.numberOfColumns];
            for (int i = 0; i < this.numberOfColumns; ++i) {
                String string = this.dbColumn[this.clmNo[i]].getDbType();
                this.dbType[i] = "NVAR".equals(string) ? 1 : ("S9".equals(string) || "R".equals(string) ? 2 : 0);
            }
        }
        return bl;
    }

    protected void writeHeader(PrintWriter printWriter) {
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Label");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            int n = this.clmNo[i];
            printWriter.print(this.dbColumn[n].getLabel());
        }
        printWriter.println();
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Name");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            int n = this.clmNo[i];
            printWriter.print(dBTableModel.getColumnName(n));
        }
        printWriter.println();
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Size");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            int n = this.clmNo[i];
            printWriter.print(this.dbColumn[n].getTotalSize());
        }
        printWriter.println();
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Class");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            int n = this.clmNo[i];
            printWriter.print(this.dbColumn[n].getClassName());
        }
        printWriter.println();
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        String string = "----";
        if (this.useNumber) {
            printWriter.print("#----");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            printWriter.print(string);
        }
        printWriter.println();
    }

    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.useNumber) {
                printWriter.print(i + 1);
                printWriter.print(this.separator);
            }
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (j != 0) {
                    printWriter.print(this.separator);
                }
                int n2 = this.clmNo[j];
                String string = (String)dBTableModel.getValue(i, n2);
                if (this.dbType[j] == 1) {
                    string = StringUtil.getReplaceEscape((String)string);
                }
                if (string != null && string.length() > 0 && string.charAt(0) == '0' && this.dbType[j] == 2) {
                    printWriter.print("'");
                }
                printWriter.print(StringUtil.rTrim((String)string));
            }
            printWriter.println();
        }
    }

    public void setDBTableModel(DBTableModel dBTableModel, String string) {
        this.table = dBTableModel;
        this.lang = string;
    }

    public DBTableModel getDBTableModel() {
        return this.table;
    }

    public void setHeaderSequence(String string) {
        if (string != null) {
            this.headerSequence = string;
        }
    }

    public String getHeaderSequence() {
        return this.headerSequence;
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setSheetName(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public void setRefSheetName(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public boolean isExcel() {
        return false;
    }

    public void setFilename(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public void setRefFilename(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public void setFontName(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    public void setFontPoint(short s) {
        String string = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }

    public void setParam(List<HybsEntry> list) {
        String string = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001XML\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void setColumns(String string) {
        this.columns = string;
    }

    protected String quotation(String string) {
        return "\"" + StringUtil.replace((String)string, (String)"\"", (String)"\"\"") + "\"";
    }
}

