<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL02"
	title	= "グループマスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	 SYSTEM_ID
				,GROUP_ID
				,ADDRESS
				,'' PUP
				,NAME_JA
				,KBNAME
				,DYSET
				,USRSET
				,DYUPD
				,USRUPD
				,PGUPD
				,UNIQ
		FROM	GE33
	<og:where>
		<og:and value = "SYSTEM_ID 	=		'{@SYSTEM_ID}'" />
		<og:and value = "GROUP_ID		like	'{@GROUP_ID}%'"	/>
		<og:and value = "ADDRESS		like	'{@ADDRESS}%'"	/>
		<og:and value = "NAME_JA			like	'{@NAME_JA}%'"		/>
		<og:and value = "KBNAME		=		'{@KBNAME}%'"	/>
		<og:and value = "COALESCE(FGJ,'0')	!=		'9'"			/>
		<og:and value = "DYSET			&gt;=   '{@DYSET_FROM}'"/>
		<og:and value = "DYSET			&lt;=   '{@DYSET_TO}'"  />
		<og:and value = "DYUPD			&gt;=   '{@DYUPD_FROM}'"/>
		<og:and value = "DYUPD			&lt;=   '{@DYUPD_TO}'"  />
	</og:where>
	<og:appear startKey = "ORDER BY" value = "GROUP_ID,ADDRESS" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->

<og:columnEditor columns="SYSTEM_ID,GROUP_ID,ADDRESS" must="true" />
<og:columnEditor column="NAME_JA"  must="true" size="15" />
<og:columnEditor column="KBNAME"    must="true" size="103"   />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<og:writeCheck>
	<og:submit value="copy"   command="COPY"   lbl="COPY"   accesskey="C" keys="SYSTEM_ID" vals="{@SYSTEM_ID}" />
	<og:submit value="modify" command="MODIFY" lbl="MODIFY" accesskey="M" />
	<og:submit value="delete" command="DELETE" lbl="DELETE" accesskey="D" />
<br />
</og:writeCheck>
<og:viewMarker command="{@command}" isRenderer="false">
    <og:popup gamenId="MAIL04" column="PUP"
               keys="USERID" vals="[ADDRESS].value"
               rtnKeys="ADDRESS,NAME_JA,KBNAME" />
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,PUP"
	selectedType = "checkbox"/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
