/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public final class SOfficeProcess {
    public static final String OFFICE_HOME = new File(System.getenv("OFFICE_HOME")).getAbsolutePath() + File.separator;
    private static final String DEFAULT_ENV_PATH = OFFICE_HOME + "env" + File.separator + "_default";
    private static final String SOFFICE_BIN = OFFICE_HOME + File.separator + "program" + File.separator + "soffice.bin";
    private static XComponentContext xLocalContext = null;
    private XDesktop desktop = null;
    private Process process = null;
    public static final String ENV_DIR;
    private final String envPath;
    private final String envId;

    protected SOfficeProcess(String string) {
        this.envId = string;
        this.envPath = ENV_DIR + this.envId;
    }

    protected void bootstrap() {
        System.out.println("[INFO]OOo:Starting soffice process,ENV-ID=" + this.envId);
        SOfficeProcess.checkEnv(this.envPath);
        String string = "uno_" + HybsSystem.sys("HOST_URL").replace(':', '_').replace('/', '_') + "_" + this.envId;
        this.process = SOfficeProcess.execOffice(this.envPath, string, 0);
        System.out.println("[INFO]OOo:Invoke soffice.bin,ENV-ID=" + this.envId);
        XUnoUrlResolver xUnoUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
        String string2 = "uno:pipe,name=" + string + ";urp;StarOffice.ComponentContext";
        XComponentContext xComponentContext = null;
        try {
            int n = 0;
            while (true) {
                try {
                    Object object = xUnoUrlResolver.resolve(string2);
                    xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
                    if (xComponentContext == null) {
                        throw new BootstrapException("no component context!");
                    }
                }
                catch (NoConnectException noConnectException) {
                    System.out.println("[INFO]OOo:Waiting for Connect soffice process,ENV-ID=" + this.envId);
                    if (n == 60) {
                        throw new BootstrapException((Exception)((Object)noConnectException));
                    }
                    Thread.sleep(1000L);
                    ++n;
                    continue;
                }
                break;
            }
            XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
            this.desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", xComponentContext));
        }
        catch (Exception exception) {
            throw new HybsSystemException("[ERROR] Can't create Desktop Instance", exception);
        }
        System.out.println("[INFO]OOo:Connected successful,ENV-ID=" + this.envId);
    }

    public XDesktop getDesktop() {
        return this.desktop;
    }

    public void close() {
        this.process.destroy();
        FileUtil.deleteFiles((File)new File(this.envPath));
        System.out.println("[INFO]OOo:Destroy process,ENV-ID=" + this.envId);
    }

    private static void checkEnv(String string) {
        if (OFFICE_HOME == null || OFFICE_HOME.length() == 0) {
            throw new HybsSystemException("OFFICE_HOME\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001OpenOffice\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093");
        }
        FileUtil.copyDirectry((String)DEFAULT_ENV_PATH, (String)string);
    }

    private static Process execOffice(String string, String string2, int n) {
        Process process;
        String[] stringArray = new String[]{SOFFICE_BIN, "-nologo", "-nodefault", "-norestore", "-nocrashreport", "-nolockcheck", "-minimized", "-invisible", "-headless", "-env:UserInstallation=file:///" + string.replace('\\', '/'), "-accept=pipe,name=" + string2 + ";urp;"};
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("[ERROR] Cant't exec soffice.bin", iOException);
        }
        return process;
    }

    static {
        try {
            xLocalContext = Bootstrap.createInitialComponentContext(null);
        }
        catch (Throwable throwable) {
            System.out.println("[ERROR]OOo:Can't start LocalContext,Check OFFICE_HOME!");
            throwable.printStackTrace();
        }
        ENV_DIR = HybsSystem.url2dir(HybsSystem.sys("FILE_URL") + "oooenv") + File.separator;
    }
}

