/**************************************************************************/
/* GF74 ( QUERY状態テーブル )                                             */
/*                                                                        */
/* Created : 2010/05/07 16:07:45                                          */
/**************************************************************************/
CREATE TABLE GF74 (
   SYSTEM_ID VARCHAR(10)                 NOT NULL                  /* 10  システムID     */
 , ADDRESS   VARCHAR(256)                                          /* 20  アドレス       */
 , PRE_FIX   VARCHAR(10)                 NOT NULL                  /* 21  名前空間       */
 , FILENAME  VARCHAR(30)                                           /* 30  ファイル名     */
 , FILEPATH  VARCHAR(256)                                          /* 40  ファイルパス   */
 , MODIFIED  VARCHAR(14)                                           /* 50  最終更新日     */
 , TAGNAME   VARCHAR(30)                                           /* 60  タグ名称       */
 , CLMS      VARCHAR(500)                                          /* 70  カラム一覧     */
 , TABLEID   VARCHAR(50)                                           /* 80  テーブルID     */
 , DBID      VARCHAR(10)                                           /* 90  データベースID */
 , SQL_TYPE  VARCHAR(20)                                           /* 100 クエリータイプ */
 , JSP_SCOPE VARCHAR(20)                                           /* 110 スコープ       */
 , SQL_TEXT  BLOB                                                  /* 120 検索           */
 , FGOMIT    VARCHAR(1)      DEFAULT '0' NOT NULL                  /* 130 除外フラグ     */
 , UNIQ      BIGINT                      NOT NULL PRIMARY KEY      /* 800 ユニークキー   */
 , FGJ       VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 810 状態フラグ     */
 , DYSET     VARCHAR(14)                                           /* 820 登録日時       */
 , PGSET     VARCHAR(10)                                           /* 830 作成PG         */
 , PGPSET    VARCHAR(10)                                           /* 840 作成親PG       */
 , USRSET    VARCHAR(10)                                           /* 850 作成社員       */
 , DYUPD     VARCHAR(14)                                           /* 860 更新日時       */
 , PGUPD     VARCHAR(10)                                           /* 870 更新PG         */
 , PGPUPD    VARCHAR(10)                                           /* 880 更新親PG       */
 , USRUPD    VARCHAR(10)                                           /* 890 更新者         */
);

CREATE SEQUENCE GF74S01 ;


CREATE TRIGGER GF74T01 FOR GF74
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF74S01,1 );
  END; 


