/**************************************************************************/
/* GF74 ( QUERY状態テーブル )                                             */
/*                                                                        */
/* Created : 2010/05/07 16:07:33                                          */
/**************************************************************************/
CREATE TABLE GF74 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , ADDRESS   VARCHAR2(256)                              /* 20  アドレス       */
 , PRE_FIX   VARCHAR2(10)                 NOT NULL      /* 21  名前空間       */
 , FILENAME  VARCHAR2(30)                               /* 30  ファイル名     */
 , FILEPATH  VARCHAR2(256)                              /* 40  ファイルパス   */
 , MODIFIED  VARCHAR2(14)                               /* 50  最終更新日     */
 , TAGNAME   VARCHAR2(30)                               /* 60  タグ名称       */
 , CLMS      VARCHAR2(500)                              /* 70  カラム一覧     */
 , TABLEID   VARCHAR2(50)                               /* 80  テーブルID     */
 , DBID      VARCHAR2(10)                               /* 90  データベースID */
 , SQL_TYPE  VARCHAR2(20)                               /* 100 クエリータイプ */
 , JSP_SCOPE VARCHAR2(20)                               /* 110 スコープ       */
 , SQL_TEXT  CLOB                                       /* 120 検索           */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 130 除外フラグ     */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー   */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ     */
 , DYSET     VARCHAR2(14)                               /* 820 登録日時       */
 , PGSET     VARCHAR2(10)                               /* 830 作成PG         */
 , PGPSET    VARCHAR2(10)                               /* 840 作成親PG       */
 , USRSET    VARCHAR2(10)                               /* 850 作成社員       */
 , DYUPD     VARCHAR2(14)                               /* 860 更新日時       */
 , PGUPD     VARCHAR2(10)                               /* 870 更新PG         */
 , PGPUPD    VARCHAR2(10)                               /* 880 更新親PG       */
 , USRUPD    VARCHAR2(10)                               /* 890 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF74S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF74T01 
BEFORE INSERT ON GF74
FOR EACH ROW 
BEGIN 
SELECT GF74S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

