/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

import java.util.Map;
import java.util.WeakHashMap;

/**
 * HybsLoaderを生成するためのファクトリクラスです。
 * HybsLoaderは、ソースディレクトリをキーとして、キャッシュされます。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class HybsLoaderFactory {

	private static final Map<String,HybsLoader> loaderMap = new WeakHashMap<String,HybsLoader>();

	/**
	 * オブジェクトの生成を禁止します。
	 */
	private HybsLoaderFactory() {} 

	/**
	 * HybsLoaderを取得します。
	 * 
	 * @param option HybsLoaderを生成するための設定情報
	 * @return HybsLoader
	 */
	public static HybsLoader getLoader( final HybsLoaderConfig option ) {
		HybsLoader loader = null;
		synchronized( HybsLoaderFactory.class ) {
			loader = loaderMap.get( option.getSrcDir() );
			if( loader == null ) {
				loader = new HybsLoader( option );
			}
			loaderMap.put( option.getSrcDir(), loader );
		}
		return loader;
	}
}