/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.opengion.fukurou.util.LogWriter;

public final class HybsCryptography {
    private final SecretKeySpec sksSpec;
    private static final String CIPHER_TYPE = "Blowfish";
    private static final String HYBS_CRYPT_KEY = "2a5a88891d37ae59";
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public HybsCryptography() {
        this.sksSpec = new SecretKeySpec(HYBS_CRYPT_KEY.getBytes(), CIPHER_TYPE);
    }

    public HybsCryptography(String string) {
        this.sksSpec = new SecretKeySpec(string.getBytes(), CIPHER_TYPE);
    }

    public String encrypt(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(1, this.sksSpec);
            byte[] byArray = cipher.doFinal(string.getBytes());
            return HybsCryptography.byte2hexa(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException(illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException(badPaddingException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
    }

    public String decrypt(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(2, this.sksSpec);
            byte[] byArray = HybsCryptography.hexa2byte(string);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException(illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException(badPaddingException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
    }

    public static String byte2hexa(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            int n = byArray.length;
            char[] cArray = new char[n * 2];
            for (int i = 0; i < n; ++i) {
                int n2 = (byArray[i] & 0xF0) >> 4;
                int n3 = byArray[i] & 0xF;
                cArray[i * 2] = hexadecimal[n2];
                cArray[i * 2 + 1] = hexadecimal[n3];
            }
            string = new String(cArray);
        }
        return string;
    }

    public static byte[] hexa2byte(String string) {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            byArray = new byte[n / 2];
            for (int i = 0; i < n / 2; ++i) {
                char c = string.charAt(i * 2);
                int n2 = c < 'a' ? c - 48 : c - 97 + 10;
                c = string.charAt(i * 2 + 1);
                int n3 = c < 'a' ? c - 48 : c - 97 + 10;
                byArray[i] = (byte)(n2 << 4 | n3);
            }
        }
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            LogWriter.log("java HybsCryptography KEY TEXT");
            LogWriter.log("  KEY  : \u79d8\u5bc6\u9375(8 \u306e\u500d\u6570 (32 \u4ee5\u4e0a 448 \u4ee5\u4e0b)\u6587\u5b57)");
            LogWriter.log("  TEXT : \u5909\u63db\u3059\u308b\u6587\u5b57\u5217");
            return;
        }
        HybsCryptography hybsCryptography = new HybsCryptography(stringArray[0]);
        System.out.println("IN   TEXT : " + stringArray[1]);
        String string = hybsCryptography.encrypt(stringArray[1]);
        System.out.println("HEXA TEXT : " + string);
        String string2 = hybsCryptography.decrypt(string);
        System.out.println("OUT  DATA : " + string2);
    }
}

