//****************************************************************
// You are free to copy the "Folder-Tree" script as long as you
// keep this copyright notice:
// Script found in: http://www.geocities.com/Paris/LeftBank/2178/
// Author: Marcelino Alves Martins (martins@hks.com) December '97.
//****************************************************************

//Log of changes:
//	17 Feb 98 - Fix initialization flashing problem with Netscape
//
//	27 Jan 98 - Root folder starts open; support for USETEXTLINKS;
//								make the ftien4 a js file
//


// Definition of class Folder
// *****************************************************************

//constructor

///Item Structure

function Folder(folderDescription, hreference, image){
	//constant data
	this.desc = folderDescription
	this.hreference = hreference
	this.id = -1
	this.navObj = 0
	this.iconImg = 0
	this.nodeImg = 0
	this.isLastNode = 0
	this.lowlevel = 1		// MIS ADD

	//dynamic data
	this.isOpen = true
	this.iconSrc = "../image/folderopen.gif"
	this.children = new Array
	this.nChildren = 0
	this.image = image					// MIS Add

	//methods
	this.initialize = initializeFolder
	this.setState = setStateFolder
	this.addChild = addChild
	this.createIndex = createEntryIndex
	this.hide = hideFolder
	this.display = display
	this.renderOb = drawFolder
//	this.totalHeight = totalHeight
	this.subEntries = folderSubEntries
	this.outputLink = outputFolderLink
}
	// initialize method
	// initialize folder
	// levbel	is LowLevel (Number)
	// lastNode is lastNode (boolean Number)
	// leftSide is HTML Tag (String)
	function initializeFolder(level, lastNode, leftSide){
		var i  = 0
		var nc = this.nChildren

		this.createIndex()
		var auxEv = "<a href='javascript:clickOnNode("+this.id+")'>"
		if (level>0){
			// if this is not root folder Item
			if (lastNode){
				//
				// the last 'brother' in the children array
				this.renderOb(leftSide + "<td class=\"tree\">" +auxEv + "<img name='nodeIcon" + this.id + "' src='../image/mlastnode.gif' width='16px' height='20px' border='0px' /></a></td>")
				leftSide = leftSide + "<td class=\"tree\"><img src='../image/blank.gif' width='16px' height='20px' /></td>"
				this.isLastNode = 1
			}else{
				this.renderOb(leftSide + "<td class=\"tree\">" + auxEv + "<img name='nodeIcon" + this.id + "' src='../image/mnode.gif' width='16px' height='20px' border='0px' /></a></td>")
				leftSide = leftSide + "<td class=\"tree\"><img src='../image/vertline.gif' width='16px' height='20px' /></td>"
				this.isLastNode = 0
			}
		}else{
			// if this is root folder Item
			this.renderOb("")
		}
		if (nc > 0){
			// if number of child Item is bigger than zero
			level = level + 1
			for (i=0 ; i < this.nChildren; i++){
				if (i == this.nChildren-1){
					// if child Item is lastNode
					this.children[i].initialize(level, 1, leftSide)
				}else{
					// if child Item is not lastNode
					this.children[i].initialize(level, 0, leftSide)
				}
			}
		}
	}
	// setState method
	// isOpen (boolean Number)
	function setStateFolder(isOpen){
		if (isOpen == this.isOpen){
			// if This Object has same attribute
			return
		}
		this.isOpen = isOpen
		propagateChangesInState(this)
	}
		function propagateChangesInState(folder){
			var i=0
			if (folder.isOpen){
				if (folder.nodeImg){
					if (folder.isLastNode){
						folder.nodeImg.src = "../image/mlastnode.gif"
					}else{
						folder.nodeImg.src = "../image/mnode.gif" //
					}
					folder.iconImg.src = "../image/folderopen.gif"
				}
				for (i=0; i<folder.nChildren; i++){
					folder.children[i].display()
				}
			}else{
				if (folder.nodeImg){
					if (folder.isLastNode){
						folder.nodeImg.src = "../image/plastnode.gif"
					}else{
						folder.nodeImg.src = "../image/pnode.gif"
					}
//					folder.iconImg.src = "../image/folderclosed.gif"
					folder.iconImg.src = "../image/" + folder.image + "Folder.gif"		// MIS Add
				}
				// hide all of childNode
				for (i=0; i<folder.nChildren; i++){
					folder.children[i].hide()
				}
			}
		}

	// addChild method
	// return childNode(Object)
	function addChild(childNode){
		this.children[this.nChildren] = childNode
		this.nChildren++	// increase number of Folder's childs
		return childNode
	}
	// hide method(Folder)
	function hideFolder(){
		if (this.navObj.style.display == "none"){
			//if this Assemble is not visible
			return
		}
		this.navObj.style.display = "none"
		this.setState(0)
	}
	// renderOb method (folder)
	function drawFolder(leftSide){
		var i=0
		var row
		if( this.lowlevel == 1 ) { row = 'row_h' }
		else                     { row = 'row_' + (this.lowlevel % 2) }
		doc.write("<tr class='" + row + "' id='folder" + this.id + "' style='position:block;' >")
//		doc.write("<tr class='row_0' id='folder" + this.id + "' style='position:block;' >")
		doc.write(leftSide)
		doc.write("<td class=\"tree\">")
		this.outputLink()
		doc.write("<img name='folderIcon" + this.id + "' src='" + this.iconSrc+"' width='16px' height='20px' border='0px' /></A>")
		doc.write("</td>")
		for (i = 0; i < maxlevel - this.lowlevel ; i++){
			doc.write("<td class=\"tree\"></td>")
		}
		doc.write("<td class=\"tree\">")
//		doc.write(this.lowlevel)
		doc.write("</td>")
		doc.write(this.desc)
		doc.write("</tr>")

		this.navObj  = doc.all["folder"+this.id]
		this.iconImg = doc.all["folderIcon"+this.id]
		this.nodeImg = doc.all["nodeIcon"+this.id]
	}
	// outputLink method
	function outputFolderLink(){
		if (this.hreference){
			doc.write("<a href='" + this.hreference + "' target=\"CONTENTS\" ")
			doc.write("onClick='javascript:clickOnFolder("+this.id+")'")
			doc.write(">")
		}else{
			doc.write("<a>")
		}
	//	doc.write("<a href='javascript:clickOnFolder("+this.id+")'>")
	}
	// subEntries method
	function folderSubEntries(){
		var i = 0
		var se = this.nChildren
		for (i=0; i < this.nChildren; i++){
			//is a folder
			if (this.children[i].children){
				se = se + this.children[i].subEntries()
			}
		}
		return se
	}

// Definition of class Item (a document or link inside a folder)
// *************************************************************

// Constructor
function Item(itemDescription, itemLink, image){
	// constant data
	this.desc = itemDescription
	this.link = itemLink
	this.id = -1 //initialized in initialize()
	this.lowlevel = 1
	this.navObj = 0 //initialized in render()
	this.iconImg = 0 //initialized in render()
//	this.iconSrc = "../image/doc.gif"
	this.iconSrc = "../image/" + image + "File.gif"		// MIS Add

	// methods
	this.initialize = initializeItem
	this.createIndex = createEntryIndex
	this.hide = hideItem
	this.display = display
	this.renderOb = drawItem
//	this.totalHeight = totalHeight
}
	// initialize method (Item)
	function initializeItem(level, lastNode, leftSide){
		this.createIndex()
		if (level>0){
			//the last 'brother' in the children array
			if (lastNode){
				this.renderOb(leftSide + "<td class=\"tree\"><img src='../image/lastnode.gif' width='16px' height='20px' /></td>")
				leftSide = leftSide + "<td class=\"tree\"><img src='../image/blank.gif' width='16px' height='20px' /></td>"
			}else{
				this.renderOb(leftSide + "<td class=\"tree\"><img src='../image/node.gif' width='16px' height='20px' /></td>")
				leftSide = leftSide + "<td class=\"tree\"><img src='../image/vertline.gif' width='16px' height='20px' /></td>"
			}
		}else{
			this.renderOb("")
		}
	}

	// hide method (Item)
	function hideItem(){
		if (this.navObj.style.display == "none"){
			return
		}
		this.navObj.style.display = "none"
	}

	// renderOb method(Item)
	function drawItem(leftSide){
		var i = 0
		var row
		if( this.lowlevel == 1 ) { row = 'row_h' }
		else                     { row = 'row_' + (this.lowlevel % 2) }
		doc.write("<tr class='" + row + "' id='item" + this.id + "' style='position:block;' >")
//		doc.write("<tr class='row_0' id='item" + this.id + "' style='position:block;' >")
		doc.write(leftSide)
		doc.write("<td class=\"tree\">")
//		doc.write("<a href=" + this.link + "><img id='itemIcon"+this.id+"' src='"+this.iconSrc+"' width='16px' height='20px' border='0px' /></A>")
		doc.write("<img id='itemIcon"+this.id+"' src='"+this.iconSrc+"' width='16px' height='20px' border='0px' />")
		doc.write("</td>")
		for (i = 0; i < maxlevel - this.lowlevel ; i++){
			doc.write("<td class=\"tree\"></td>")
		}
		doc.write("<td class=\"tree\">")
//		doc.write(this.lowlevel)
		doc.write("</td>")
		doc.write(this.desc)
		doc.write("</tr>")

		this.navObj = doc.all["item"+this.id]
		this.iconImg = doc.all["itemIcon"+this.id]
	}
	// Methods common to both objects (pseudo-inheritance)
	// ********************************************************
	//Folder method and Item method
	function display(){
		this.navObj.style.display = "block"
	}
	// createIndex method
	function createEntryIndex(){
		this.id = nEntries
		indexOfEntries[nEntries] = this
		nEntries++
	}


	//total height of subEntries open
	//used with browserVersion == 2
//	function totalHeight(){
//		var h = this.navObj.clip.height
//		var i = 0
//		//is a folder and _is_ open
//		if (this.isOpen){
//			for (i=0 ; i < this.nChildren; i++){
//				h = h + this.children[i].totalHeight()
//			}
//		}
//		return h
//	}

// Events
// *********************************************************

// clickOnAsssembly action
function clickOnFolder(folderID){
	var clicked = indexOfEntries[folderID] // clieked(Object)
	if (!clicked.isOpen){
		// if folder is closed
		clickOnNode(folderID)
	}
	return
}
// clickOnNode action
function clickOnNode(folderID){
	var clickedFolder = 0	//clickedfolder is folder(Obect)
	var state = 0
	clickedFolder = indexOfEntries[folderID]
	state = clickedFolder.isOpen

	//open<->close
	clickedFolder.setState(!state)
}

function initializeDocument(){
//	doc.write("<thead><tr>")
//	for (i = 0; i < maxlevel ; i++){
//		doc.write("<th class=\"tree\"></th>")
//	}
//	doc.write("<th class=\"tree\">"+itemHeader.desc+"</th>")
//	doc.write("</tr></thead>")

	doc.write("<tbody>")
//	folderTree.initialize(0, 1, "")
	aux0.initialize(0, 1, "")
	doc.write("</tbody>")

//	folderTree.display()
	aux0.display()

	// open the root folder
	clickOnNode(0)
	// close the whole tree
	clickOnFolder(0)
}

// Auxiliary Functions for folder-Tree backward compatibility
// *********************************************************

//function createItemHeader(description){
//	folder = new Folder(description, "")
//	return folder
//}

function gFld(description, hreference, image){
	folder = new Folder(description, hreference, image)
	return folder
}

function gLnk(target, description, linkData, image){
	fullLink = ""

//	if (target==0){
//		fullLink = "'"+linkData+"' target=\"baseframe\""
//	}else{
//		if (target==1) {
//			fullLink = "'http://"+linkData+"' target=_blank"
//		}
//		else{
//			fullLink = "'http://"+linkData+"' target=\"baseframe\""
//		}
//	}
	fullLink = "'"+linkData+"' target=\""+target+"\"" 		// MIS Add
	linkItem = new Item(description, fullLink, image)
	return linkItem
}

function insFld(parentFolder, childFolder) {
	childFolder.lowlevel = parentFolder.lowlevel + 1
	if ( maxlevel < childFolder.lowlevel ){
		maxlevel = childFolder.lowlevel
	}
	return parentFolder.addChild(childFolder)
}


//function insDoc(parentFolder, document){
//	parentFolder.addChild(document)
//}

// Global variables
// ****************

USETEXTLINKS = 1
indexOfEntries = new Array
nEntries = 0
maxlevel = 0
doc = document
browserVersion = 0
selectedItem=0

