/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.xml.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseConfig {
    private static final String DEFAULT_DRIVER = "oracle.jdbc.OracleDriver";
    private final String XmlFilename;
    private final Map<String, EDbid> dbidMap = new HashMap<String, EDbid>();

    public DatabaseConfig() {
        this("../DBConfig.xml");
    }

    public DatabaseConfig(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        this.XmlFilename = uRL.getFile();
        System.out.println(this.XmlFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EDbid getDbid(String string) {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            if (this.dbidMap.isEmpty()) {
                this.init();
            }
            return this.dbidMap.get(string.toUpperCase(Locale.JAPAN));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            this.dbidMap.clear();
        }
    }

    private void init() {
        Document document = DomParser.read(new File(this.XmlFilename));
        Element element = document.getDocumentElement();
        List<String> list = this.getDriverList(element);
        for (String string : list) {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]";
                LogWriter.log(string2);
                LogWriter.log(classNotFoundException);
            }
        }
        EDbid eDbid = new EDbid();
        eDbid.setUrl(System.getenv("REALM_URL"));
        eDbid.setUser(System.getenv("REALM_NAME"));
        eDbid.setPassword(System.getenv("REALM_PASSWORD"));
        this.makeDbidMap(element, eDbid);
    }

    private List<String> getDriverList(Element element) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("class");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(element2.getTextContent());
        }
        if (arrayList.isEmpty() && (string = System.getenv("REALM_DRIVER")) != null && string.length() > 0) {
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(DEFAULT_DRIVER);
        }
        return arrayList;
    }

    private void makeDbidMap(Element element, EDbid eDbid) {
        NodeList nodeList = element.getElementsByTagName("dbid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getChildNodes();
            int n2 = nodeList2.getLength();
            EDbid eDbid2 = eDbid.clone();
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                if (node.getNodeType() != 1) continue;
                Element element3 = (Element)node;
                String string = element3.getTagName();
                if ("dbidKey".equals(string)) {
                    String string2 = element3.getTextContent();
                    if (string2 == null || string2.length() <= 0) continue;
                    eDbid2.setDbidKey(string2.toUpperCase(Locale.JAPAN));
                    continue;
                }
                if ("url".equals(string)) {
                    eDbid2.setUrl(element3.getTextContent());
                    continue;
                }
                if ("user".equals(string)) {
                    eDbid2.setUser(element3.getTextContent());
                    continue;
                }
                if ("password".equals(string)) {
                    eDbid2.setPassword(element3.getTextContent());
                    continue;
                }
                if ("readonly".equals(string)) {
                    eDbid2.setReadonly(element3.getTextContent());
                    continue;
                }
                if ("mincount".equals(string)) {
                    eDbid2.setMincount(element3.getTextContent());
                    continue;
                }
                if ("maxcount".equals(string)) {
                    eDbid2.setMaxcount(element3.getTextContent());
                    continue;
                }
                if ("pooltime".equals(string)) {
                    eDbid2.setPooltime(element3.getTextContent());
                    continue;
                }
                if ("applicationInfo".equals(string)) {
                    eDbid2.setApplicationInfo(element3.getTextContent());
                    continue;
                }
                System.err.println("\u8b66\u544a\uff1adbid \u306b\u65b0\u3057\u3044\u5c5e\u6027\u304c\u3001\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            this.dbidMap.put(eDbid2.getDbidKey(), eDbid2);
        }
    }
}

