/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TransactionTag;

public class ValueTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    public static final String CMD_SET = "SET";
    public static final String CMD_GET = "GET";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_CLEAR = "CLEAR";
    public static final String CMD_SQL = "SQL";
    public static final String CMD_SETTBL = "SETTBL";
    public static final String CMD_GETTBL = "GETTBL";
    public static final String CMD_KEYTBL = "KEYTBL";
    public static final String CMD_SETMEM = "SETMEM";
    public static final String CMD_SQLGET = "SQLGET";
    private static final String[] COMMAND_LIST = new String[]{"SET", "GET", "REMOVE", "SQL", "SETTBL", "GETTBL", "KEYTBL", "CLEAR", "SETMEM", "SQLGET"};
    public static final String ACT_UPPER = "UPPER";
    public static final String ACT_LOWER = "LOWER";
    public static final String ACT_MESSAGE = "MESSAGE";
    public static final String ACT_APPEND = "APPEND";
    public static final String ACT_ALL_APPEND = "ALL_APPEND";
    public static final String ACT_LIST = "LIST";
    public static final String ACT_ALL_LIST = "ALL_LIST";
    public static final String ACT_DAY_WEEK = "DAY_WEEK";
    public static final String ACT_MERGE = "MERGE";
    public static final String ACT_FIRST = "FIRST";
    public static final String ACT_ROW_APPEND = "ROW_APPEND";
    private static final String[] ACTION_LIST = new String[]{"UPPER", "LOWER", "MESSAGE", "APPEND", "ALL_APPEND", "LIST", "ALL_LIST", "DAY_WEEK", "MERGE", "FIRST", "ROW_APPEND"};
    private String tableId = "h_tblmdl";
    private String command = "SET";
    private String key = null;
    private String inValue = null;
    private String value = null;
    private String defaultVal = null;
    private String action = null;
    private transient DBTableModel table = null;
    private String dbid = null;
    private String scope = "request";
    private String tblScope = "session";
    private String separator = ",";
    private String parameter = null;
    private boolean useMultiRows = false;
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");

    @Override
    public int doStartTag() {
        super.setScope(this.scope);
        if (CMD_SQL.equals(this.command) || CMD_SET.equals(this.command) || CMD_SQLGET.equals(this.command)) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        if (this.value == null || this.value.length() <= 0) {
            this.useXssCheck(this.xssCheck);
            this.value = this.getBodyString();
            if (CMD_SQL.equals(this.command) || CMD_SQLGET.equals(this.command)) {
                Query query = QueryFactory.newInstance();
                try {
                    this.value = this.value.trim();
                    TransactionTag transactionTag = (TransactionTag)ValueTag.findAncestorWithClass((Tag)this, TransactionTag.class);
                    Object object = transactionTag == null ? new TransactionReal(this.dbid, this.getApplicationInfo()) : transactionTag.getTransaction();
                    query.setTransaction(this.dbid, (Transaction)object);
                    query.setResourceManager(this.getResource());
                    query.setStatement(this.value);
                    query.execute();
                    this.table = query.getDBTableModel();
                }
                finally {
                    if (query != null) {
                        query.close();
                    }
                    QueryFactory.close(query);
                }
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.check(this.command, COMMAND_LIST) && (CMD_SETTBL.equals(this.command) || CMD_GETTBL.equals(this.command) || CMD_KEYTBL.equals(this.command))) {
            if ("session".equals(this.tblScope)) {
                this.table = (DBTableModel)this.getSessionAttribute(this.tableId);
            } else if ("request".equals(this.tblScope)) {
                this.table = (DBTableModel)this.getRequestAttribute(this.tableId);
            } else {
                String string = "\u3053\u306e\u30b9\u30b3\u30fc\u30d7\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[" + this.tblScope + "]";
                throw new IllegalArgumentException(string);
            }
        }
        this.commandExec(this.command);
        if ((CMD_GET.equals(this.command) || CMD_GETTBL.equals(this.command) || CMD_SQLGET.equals(this.command)) && this.value != null) {
            this.jspPrint(this.value);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.command = CMD_SET;
        this.key = null;
        this.value = null;
        this.defaultVal = null;
        this.action = null;
        this.table = null;
        this.dbid = null;
        this.scope = "request";
        this.tblScope = "session";
        this.separator = ",";
        this.parameter = null;
        this.useMultiRows = false;
        this.inValue = null;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    }

    private void commandExec(String string) {
        if (CMD_SQL.equals(string)) {
            this.setSQLAttribute(this.table);
        } else if (CMD_SQLGET.equals(string)) {
            this.value = this.getSQLAttribute(this.table);
        } else if (CMD_SET.equals(string)) {
            this.value = StringUtil.nval((String)this.value, (String)this.defaultVal);
            this.setAttribute(this.key, this.value, this.action);
        } else if (CMD_GET.equals(string)) {
            this.value = this.getAttribute(this.key, this.action);
        } else if (CMD_REMOVE.equals(string)) {
            this.removeAttribute(this.key);
        } else if (CMD_CLEAR.equals(string)) {
            this.clearAttribute(this.key);
        } else if (CMD_SETTBL.equals(string)) {
            this.setTableAttribute(this.table, this.key, this.action);
        } else if (CMD_GETTBL.equals(string)) {
            this.value = this.getTableAttribute(this.table, this.key, this.action);
        } else if (CMD_KEYTBL.equals(string)) {
            this.setKeyTableAttribute(this.table, this.key, this.value, this.action);
        } else if (CMD_SETMEM.equals(string)) {
            this.value = StringUtil.nval((String)this.value, (String)this.defaultVal);
            this.setAttribute(this.key, this.value, this.action);
            this.setRequestCacheData(this.key, (String)this.getObject(this.key));
        }
    }

    private String actionExec(String string, String string2) {
        String string3 = string2;
        if (string == null) {
            return string3;
        }
        if (ACT_UPPER.equals(string)) {
            string3 = string2.toUpperCase(Locale.JAPAN);
        } else if (ACT_LOWER.equals(string)) {
            string3 = string2.toLowerCase(Locale.JAPAN);
        } else if (ACT_MESSAGE.equals(string)) {
            string3 = this.getResource().getLabel(string2);
        } else if (ACT_DAY_WEEK.equals(string)) {
            Calendar calendar = HybsSystem.getCalendar(string2);
            int n = calendar.get(7) - 2;
            if (n != 0) {
                calendar.add(5, -n);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
            string3 = simpleDateFormat.format(calendar.getTime());
        } else if (ACT_MERGE.equals(string)) {
            String[] stringArray = StringUtil.csv2Array((String)string2);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                linkedHashSet.add(stringArray[i]);
            }
            string3 = StringUtil.iterator2line(linkedHashSet.iterator(), (String)",");
        }
        return string3;
    }

    private void setAttribute(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string3 + " , value=" + string2;
            throw new HybsSystemException(string4);
        }
        if (ACT_APPEND.equals(string3)) {
            String[] stringArray = this.getRequestParameterValues(this.inValue);
            this.setObject(string, StringUtil.array2line((String[])stringArray, (String)this.separator));
        } else {
            this.setObject(string, this.actionExec(string3, string2));
        }
    }

    private String getAttribute(String string, String string2) {
        if (string == null || string.length() == 0) {
            String string3 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2;
            throw new HybsSystemException(string3);
        }
        String string4 = this.defaultVal;
        Object object = this.pageContext.findAttribute(string);
        if (object != null) {
            string4 = object.toString();
        }
        return this.actionExec(string2, string4);
    }

    private void removeAttribute(String string) {
        if (string == null || string.length() == 0) {
            String string2 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command;
            throw new HybsSystemException(string2);
        }
        this.removeObject(string);
    }

    private void clearAttribute(String string) {
        String string2;
        String string3 = null;
        if (string != null) {
            string3 = string.toLowerCase(Locale.JAPAN);
        }
        Enumeration enumeration = this.pageContext.getAttributeNamesInScope(4);
        while (enumeration.hasMoreElements()) {
            string2 = ((String)enumeration.nextElement()).toLowerCase(Locale.JAPAN);
            if (string2.startsWith("h_") || string2.startsWith("x_") || string3 != null && !string2.startsWith(string)) continue;
            this.pageContext.removeAttribute(string2, 4);
        }
        enumeration = this.pageContext.getAttributeNamesInScope(3);
        while (enumeration.hasMoreElements()) {
            string2 = String.valueOf(enumeration.nextElement()).toLowerCase(Locale.JAPAN);
            if (string2.startsWith("h_") || string2.startsWith("x_") || string3 != null && !string2.startsWith(string)) continue;
            this.pageContext.removeAttribute(string2, 3);
        }
    }

    private void setSQLAttribute(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return;
        }
        int n = dBTableModel.getColumnCount();
        int n2 = dBTableModel.getRowCount();
        String string = "";
        if (ACT_ROW_APPEND.equals(this.action)) {
            for (int i = 0; i < n; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < n2; ++j) {
                    String string2 = (String)dBTableModel.getValue(j, i);
                    if (j > 0) {
                        stringBuilder.append(this.separator);
                    }
                    stringBuilder.append(string2);
                }
                String string3 = dBTableModel.getColumnName(i);
                this.setObject(string3, stringBuilder.toString());
            }
        } else if (ACT_ALL_LIST.equals(this.action) || ACT_LIST.equals(this.action)) {
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j < n2; ++j) {
                    String string4 = (String)dBTableModel.getValue(j, i);
                    arrayList.add(string4);
                }
                String string5 = dBTableModel.getColumnName(i);
                this.setObject(string5, arrayList);
            }
        } else if (n2 == 0) {
            if (this.useMultiRows) {
                string = "0";
            }
            for (int i = 0; i < n; ++i) {
                String string6 = dBTableModel.getColumnName(i);
                String string7 = "";
                this.setObject(string6 + string, string7);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (this.useMultiRows) {
                    string = String.valueOf(i);
                }
                for (int j = 0; j < n; ++j) {
                    String string8 = dBTableModel.getColumnName(j);
                    String string9 = (String)dBTableModel.getValue(i, j);
                    this.setObject(string8 + string, string9);
                }
                if (this.useMultiRows) {
                    continue;
                }
                break;
            }
        }
    }

    private String getSQLAttribute(DBTableModel dBTableModel) {
        String string;
        if (dBTableModel == null) {
            return "";
        }
        int n = dBTableModel.getRowCount();
        if (ACT_ROW_APPEND.equals(this.action)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.separator);
                }
                stringBuilder.append((String)dBTableModel.getValue(i, 0));
            }
            string = stringBuilder.toString();
        } else {
            string = n == 0 ? "" : (String)dBTableModel.getValue(0, 0);
        }
        return string;
    }

    private void setTableAttribute(DBTableModel dBTableModel, String string, String string2) {
        if (dBTableModel == null || dBTableModel.getRowCount() == 0 || dBTableModel.getColumnCount() == 0) {
            return;
        }
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0 && !ACT_ALL_APPEND.equals(string2)) {
            return;
        }
        String[] stringArray = string == null || string.length() == 0 ? dBTableModel.getNames() : new String[]{string};
        if (ACT_APPEND.equals(string2)) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)dBTableModel.getValue(nArray[0], n));
                for (int j = 1; j < nArray.length; ++j) {
                    stringBuilder.append(this.separator);
                    stringBuilder.append((String)dBTableModel.getValue(nArray[j], n));
                }
                this.setObject(stringArray[i], stringBuilder.toString());
            }
        } else if (ACT_ALL_APPEND.equals(string2)) {
            int n = dBTableModel.getRowCount();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = dBTableModel.getColumnNo(stringArray[i]);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)dBTableModel.getValue(0, n2));
                for (int j = 1; j < n; ++j) {
                    stringBuilder.append(this.separator);
                    stringBuilder.append((String)dBTableModel.getValue(j, n2));
                }
                this.setObject(stringArray[i], stringBuilder.toString());
            }
        } else if (ACT_LIST.equals(string2)) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int j = 0; j < nArray.length; ++j) {
                    arrayList.add(dBTableModel.getValue(nArray[j], n));
                }
                this.setObject(stringArray[i], arrayList);
            }
        } else if (ACT_ALL_LIST.equals(string2)) {
            int n = dBTableModel.getRowCount();
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = dBTableModel.getColumnNo(stringArray[i]);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int j = 0; j < n; ++j) {
                    arrayList.add(dBTableModel.getValue(j, n3));
                }
                this.setObject(stringArray[i], arrayList);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                this.setAttribute(stringArray[i], (String)dBTableModel.getValue(nArray[0], n), string2);
            }
        }
    }

    private String getTableAttribute(DBTableModel dBTableModel, String string, String string2) {
        if (dBTableModel == null) {
            String string3 = "table \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2 + " , key=" + string;
            throw new HybsSystemException(string3);
        }
        if (string == null || string.length() == 0) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2;
            throw new HybsSystemException(string4);
        }
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0 && !ACT_ALL_APPEND.equals(string2)) {
            return "";
        }
        int n = dBTableModel.getColumnNo(string);
        if (ACT_APPEND.equals(string2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)dBTableModel.getValue(nArray[0], n));
            for (int i = 1; i < nArray.length; ++i) {
                stringBuilder.append(this.separator);
                stringBuilder.append((String)dBTableModel.getValue(nArray[i], n));
            }
            return stringBuilder.toString();
        }
        if (ACT_ALL_APPEND.equals(string2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)dBTableModel.getValue(0, n));
            int n2 = dBTableModel.getRowCount();
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(this.separator);
                stringBuilder.append((String)dBTableModel.getValue(i, n));
            }
            return stringBuilder.toString();
        }
        return this.actionExec(string2, (String)dBTableModel.getValue(nArray[0], n));
    }

    private void setKeyTableAttribute(DBTableModel dBTableModel, String string, String string2, String string3) {
        int[] nArray;
        if (dBTableModel == null) {
            return;
        }
        if (string == null || string.length() == 0) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string3 + " , value=" + string2;
            throw new HybsSystemException(string4);
        }
        int[] nArray2 = this.getParameterRows();
        if (nArray2.length == 0) {
            return;
        }
        if (string2 == null || string2.length() == 0) {
            String[] stringArray = dBTableModel.getNames();
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i]);
            }
        } else {
            nArray = new int[]{dBTableModel.getColumnNo(string2)};
        }
        for (int i = 0; i < nArray2.length; ++i) {
            String string5 = string + i;
            if (ACT_APPEND.equals(string3)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)dBTableModel.getValue(nArray2[i], nArray[0]));
                for (int j = 1; j < nArray.length; ++j) {
                    stringBuilder.append(this.separator);
                    stringBuilder.append((String)dBTableModel.getValue(nArray2[i], nArray[j]));
                }
                this.setObject(string5, stringBuilder.toString());
                continue;
            }
            this.setAttribute(string5, (String)dBTableModel.getValue(nArray2[i], nArray[0]), string3);
        }
    }

    @Override
    protected int[] getParameterRows() {
        if (ACT_FIRST.equals(this.action)) {
            return new int[]{0};
        }
        return super.getParameterRows();
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command).toUpperCase(Locale.JAPAN);
        if (!this.check(this.command, COMMAND_LIST)) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("\u6307\u5b9a\u306e\u30b3\u30de\u30f3\u30c9\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30b3\u30de\u30f3\u30c9\u30a8\u30e9\u30fc");
            stringBuilder.append(HybsSystem.CR);
            stringBuilder.append("command=[").append(this.command).append("] ");
            stringBuilder.append(HybsSystem.CR);
            for (int i = 0; i < COMMAND_LIST.length; ++i) {
                stringBuilder.append(" | ");
                stringBuilder.append(COMMAND_LIST[i]);
            }
            stringBuilder.append(" | ");
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (this.action != null && !this.check(this.action, ACTION_LIST)) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc");
            stringBuilder.append(HybsSystem.CR);
            stringBuilder.append("action=[").append(this.action).append("] ");
            stringBuilder.append(HybsSystem.CR);
            for (int i = 0; i < ACTION_LIST.length; ++i) {
                stringBuilder.append(" | ");
                stringBuilder.append(ACTION_LIST[i]);
            }
            stringBuilder.append(" | ");
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setKey(String string) {
        this.key = StringUtil.nval((String)this.getRequestParameter(string), (String)this.key);
        if (this.key == null) {
            String string2 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + this.action;
            throw new HybsSystemException(string2);
        }
    }

    public void setValue(String string) {
        this.inValue = string;
        this.value = this.getRequestParameter(this.inValue);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = this.getRequestParameter(string);
    }

    @Deprecated
    public void setNullSet(String string) {
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    @Override
    public void setScope(String string) {
        this.scope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.scope);
    }

    public void setTblScope(String string) {
        this.tblScope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tblScope);
    }

    public void setParameter(String string) {
        this.parameter = StringUtil.nval((String)this.getRequestParameter(string), (String)this.parameter);
    }

    public void setUseMultiRows(String string) {
        this.useMultiRows = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMultiRows);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        String string;
        String string2 = ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("key", (Object)this.key).println("inValue", (Object)this.inValue).println("value", (Object)this.value).println("defaultVal", (Object)this.defaultVal).println("action", (Object)this.action).println("dbid", (Object)this.dbid).println("scope", (Object)this.scope).println("separator", (Object)this.separator).println("parameter", (Object)this.parameter).println("useMultiRows", (Object)this.useMultiRows).println("COMMAND_LIST", (Object[])COMMAND_LIST).println("ACTION_LIST", (Object[])ACTION_LIST).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(HybsSystem.CR).append("====================================").append(HybsSystem.CR);
        stringBuilder.append("APPLICATION_SCOPE:").append(HybsSystem.CR);
        Enumeration enumeration = this.pageContext.getAttributeNamesInScope(4);
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuilder.append("  key=[").append(string).append("] ");
            stringBuilder.append("value=[").append(this.pageContext.getAttribute(string, 4)).append("]");
            stringBuilder.append(HybsSystem.CR);
        }
        stringBuilder.append("SESSION_SCOPE:").append(HybsSystem.CR);
        enumeration = this.pageContext.getAttributeNamesInScope(3);
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(enumeration.nextElement());
            stringBuilder.append("  key=[").append(string).append("] ");
            stringBuilder.append("value=[").append(this.pageContext.getAttribute(string, 3)).append("]");
            stringBuilder.append(HybsSystem.CR);
        }
        stringBuilder.append("REQUEST_SCOPE:").append(HybsSystem.CR);
        enumeration = this.pageContext.getAttributeNamesInScope(2);
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(enumeration.nextElement());
            stringBuilder.append("  key=[").append(string).append("] ");
            stringBuilder.append("value=[").append(this.pageContext.getAttribute(string, 2)).append("]");
            stringBuilder.append(HybsSystem.CR);
        }
        stringBuilder.append("PAGE_SCOPE:").append(HybsSystem.CR);
        enumeration = this.pageContext.getAttributeNamesInScope(1);
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(enumeration.nextElement());
            stringBuilder.append("  key=[").append(string).append("] ");
            stringBuilder.append("value=[").append(this.pageContext.getAttribute(string, 1)).append("]");
            stringBuilder.append(HybsSystem.CR);
        }
        stringBuilder.append("====================================").append(HybsSystem.CR);
        return string2 + stringBuilder.toString();
    }
}

