/**************************************************************************/
/* GE39 ( ファイル管理テーブル )                                          */
/*                                                                        */
/* Created : 2010/08/02 13:06:20                                          */
/**************************************************************************/
CREATE TABLE GE39 (
   UNIQ_ID     VARCHAR(10)                 NOT NULL                  /* 10  UNIQ番号         */
 , SEQNO       NUMERIC(7)      DEFAULT 0   NOT NULL                  /* 20  表示順           */
 , SUFFIX      VARCHAR(10)                                           /* 30  拡張子           */
 , REF_KEY     VARCHAR(100)                NOT NULL                  /* 40  関連キー         */
 , SYSTEM_ID   VARCHAR(10)                 NOT NULL                  /* 50  システムID       */
 , SYKEY       VARCHAR(10)                 NOT NULL                  /* 60  種別キー         */
 , SYFILE      VARCHAR(100)                                          /* 70  ファイル種別     */
 , SYNAME      VARCHAR(200)                                          /* 80  種別名称         */
 , SAVE_FOLDER VARCHAR(300)                                          /* 90  保管フォルダ     */
 , FILE_URL    VARCHAR(300)                                          /* 100 ファイルURL      */
 , ICON_URL    VARCHAR(300)                                          /* 110 アイコンURL      */
 , ROLES       VARCHAR(500)                                          /* 120 ロールズ         */
 , SU_LMT      NUMERIC(5)      DEFAULT 0   NOT NULL                  /* 130 閲覧制限数       */
 , DY_LMT      NUMERIC(5)      DEFAULT 0   NOT NULL                  /* 140 閲覧期日         */
 , FGANGO      VARCHAR(1)      DEFAULT '0' NOT NULL                  /* 150 暗号化FG         */
 , FGZIP       VARCHAR(1)      DEFAULT '0' NOT NULL                  /* 160 圧縮FG           */
 , FILE_NAME   VARCHAR(500)                                          /* 170 ファイル名称     */
 , CONTENTS    BLOB                                                  /* 180 内容             */
 , FG_NEW      VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 190 最新FG           */
 , SIZE_FILE   NUMERIC(9)      DEFAULT 0   NOT NULL                  /* 200 ファイルサイズ   */
 , DYFILESET   VARCHAR(14)                                           /* 210 ファイル登録日時 */
 , USRTOROKU   VARCHAR(10)                                           /* 220 ファイル登録者   */
 , SETGUIID    VARCHAR(10)                                           /* 230 登録画面ID       */
 , FGKOSHIN    VARCHAR(1)      DEFAULT '1'                           /* 240 変更許可FG       */
 , FGKOKAI     VARCHAR(1)      DEFAULT '1'                           /* 250 公開許可FG       */
 , UNIQ        BIGINT                      NOT NULL PRIMARY KEY      /* 260 ユニークキー     */
 , FGJ         VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 270 状態フラグ       */
 , DYSET       VARCHAR(14)                                           /* 280 登録日時         */
 , PGSET       VARCHAR(10)                                           /* 290 作成PG           */
 , PGPSET      VARCHAR(10)                                           /* 300 作成親PG         */
 , USRSET      VARCHAR(10)                                           /* 310 作成社員         */
 , DYUPD       VARCHAR(14)                                           /* 320 更新日時         */
 , PGUPD       VARCHAR(10)                                           /* 330 更新PG           */
 , PGPUPD      VARCHAR(10)                                           /* 340 更新親PG         */
 , USRUPD      VARCHAR(10)                                           /* 350 更新者           */
);

CREATE SEQUENCE GE39S00 ;


CREATE TRIGGER GE39T00 FOR GE39
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GE39S00,1 );
  END; 


