/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.opengion.hayabusa.io.HybsCategoryAxis;
import org.opengion.hayabusa.io.HybsDrawItem;

public class HybsBarRenderer
extends BarRenderer
implements HybsDrawItem {
    private static final long serialVersionUID = 4110L;
    private boolean isItemLabelLastVisible = false;
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();

    @Override
    public void setItemLabelLastVisible(boolean bl) {
        this.isItemLabelLastVisible = bl;
    }

    @Override
    public void drawItem2(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n) {
        int n2 = categoryDataset.getColumnCount();
        int n3 = categoryDataset.getRowCount();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = this.getMinimumBarLength();
        double d2 = categoryItemRendererState.getBarWidth();
        boolean bl = this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0;
        HybsCategoryAxis hybsCategoryAxis = null;
        if (categoryAxis instanceof HybsCategoryAxis) {
            hybsCategoryAxis = (HybsCategoryAxis)categoryAxis;
            hybsCategoryAxis.setItemLabelLastVisible(this.isItemLabelLastVisible);
        }
        for (int i = 0; i < n3; ++i) {
            boolean bl2 = this.isSeriesItemLabelsVisible(i);
            for (int j = 0; j < n2; ++j) {
                Paint paint;
                Stroke stroke;
                Number number = categoryDataset.getValue(i, j);
                if (number == null) continue;
                double d3 = number.doubleValue();
                double d4 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, i, j);
                double[] dArray = this.calculateBarL0L1(d3);
                if (dArray == null) continue;
                double d5 = valueAxis.valueToJava2D(dArray[0], rectangle2D, rectangleEdge);
                double d6 = valueAxis.valueToJava2D(dArray[1], rectangle2D, rectangleEdge);
                double d7 = Math.min(d5, d6);
                double d8 = Math.max(Math.abs(d6 - d5), d);
                Rectangle2D.Double double_ = null;
                double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d7, d4, d8, d2) : new Rectangle2D.Double(d4, d7, d2, d8);
                Paint paint2 = this.getItemPaint(i, j);
                GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
                if (gradientPaintTransformer != null && paint2 instanceof GradientPaint) {
                    paint2 = gradientPaintTransformer.transform((GradientPaint)paint2, (Shape)double_);
                }
                graphics2D.setPaint(paint2);
                graphics2D.fill(double_);
                if (bl) {
                    stroke = this.getItemOutlineStroke(i, j);
                    paint = this.getItemOutlinePaint(i, j);
                    if (stroke != null && paint != null) {
                        graphics2D.setStroke(stroke);
                        graphics2D.setPaint(paint);
                        graphics2D.draw(double_);
                    }
                }
                if ((stroke = this.getItemLabelGenerator(i, j)) != null && bl2 && hybsCategoryAxis != null && hybsCategoryAxis.isViewItemLabel(j)) {
                    this.drawItemLabel(graphics2D, categoryDataset, i, j, categoryPlot, (CategoryItemLabelGenerator)stroke, double_, d3 < 0.0);
                }
                if ((paint = categoryItemRendererState.getEntityCollection()) == null) continue;
                this.addItemEntity((EntityCollection)paint, categoryDataset, i, j, double_);
            }
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this.hsCode == ((HybsBarRenderer)object).hsCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hsCode;
    }
}

