/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.NoSuchElementException;

public class CSVTokenizer {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private char delimChar;
    private boolean inQuoteFlag;

    public CSVTokenizer(String string, char c, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimChar = c;
        this.inQuoteFlag = bl;
    }

    public CSVTokenizer(String string, char c) {
        this(string, c, true);
    }

    public CSVTokenizer(String string) {
        this(string, ',', true);
    }

    private int skipDelimiters(int n) {
        int n2;
        boolean bl = false;
        for (n2 = n; n2 < this.maxPosition; ++n2) {
            char c = this.str.charAt(n2);
            if (!bl && c == this.delimChar) break;
            if ('\"' != c || !this.inQuoteFlag) continue;
            bl = !bl;
        }
        return n2;
    }

    public boolean hasMoreTokens() {
        int n = this.skipDelimiters(this.currentPosition);
        return n <= this.maxPosition;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(this.toString() + "#nextToken");
        }
        int n = this.currentPosition;
        int n2 = this.skipDelimiters(this.currentPosition);
        this.currentPosition = n2 + 1;
        if (this.inQuoteFlag && n < this.maxPosition && n < n2 && this.str.charAt(n) == '\"' && this.str.charAt(n2 - 1) == '\"') {
            ++n;
            --n2;
        }
        return this.str.substring(n, n2);
    }

    public int countTokens() {
        int n = 1;
        int n2 = 0;
        while ((n2 = this.skipDelimiters(n2)) < this.maxPosition) {
            ++n2;
            ++n;
        }
        return n;
    }

    public String toString() {
        return "CSVTokenizer(" + this.str + ")";
    }
}

