/**************************************************************************/
/* GEA09 ( ユーザーアクセス画面管理テーブル )                             */
/*                                                                        */
/* Created : 2010/08/02 13:06:20                                          */
/**************************************************************************/
CREATE TABLE GEA09 (
   SYSTEM_ID   VARCHAR(10)                 NOT NULL                  /* 10  システムID       */
 , USERID      VARCHAR(10)                 NOT NULL                  /* 20  ユーザーID       */
 , GUIKEY      VARCHAR(30)                 NOT NULL                  /* 30  画面ID           */
 , SEQNO       NUMERIC(7)      DEFAULT 0   NOT NULL                  /* 40  表示順           */
 , NAME_JA     VARCHAR(200)                                          /* 50  名称             */
 , LAST_ACCESS VARCHAR(14)                                           /* 60  最終アクセス時間 */
 , FGFAVORITE  VARCHAR(1)                                            /* 70  お気に入り       */
 , CLASSIFY    VARCHAR(120)                                          /* 80  分類             */
 , UNIQ        BIGINT                      NOT NULL PRIMARY KEY      /* 800 ユニークキー     */
 , FGJ         VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 810 状態フラグ       */
 , DYSET       VARCHAR(14)                                           /* 820 登録日時         */
 , PGSET       VARCHAR(10)                                           /* 830 作成PG           */
 , PGPSET      VARCHAR(10)                                           /* 840 作成親PG         */
 , USRSET      VARCHAR(10)                                           /* 850 作成社員         */
 , DYUPD       VARCHAR(14)                                           /* 860 更新日時         */
 , PGUPD       VARCHAR(10)                                           /* 870 更新PG           */
 , PGPUPD      VARCHAR(10)                                           /* 880 更新親PG         */
 , USRUPD      VARCHAR(10)                                           /* 890 更新者           */
);

CREATE SEQUENCE GEA09S00 ;


CREATE TRIGGER GEA09T00 FOR GEA09
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GEA09S00,1 );
  END; 


