<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "CUBE_X,CUBE_Y"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		SELECT {@CUBE_X},{@CUBE_Y},SAL AS KEI
		FROM EMP
		ORDER BY {@CUBE_X},{@CUBE_Y}
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="{@CUBE_X}" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		keys="command,{@CUBE_X},KEI"
		vals="NEW,[{@CUBE_X}],[KEI]" />
	<og:link column="KEI" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		keys="command,KEI"
		vals="NEW,[KEI]" />
</og:viewLink>

<og:view
	viewFormType = "HTMLCrossTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useParam   = "true"
  >
	<og:crossParam
		cubeXColumn		= "{@CUBE_X}"
		cubeYColumn		= "{@CUBE_Y}"
		gokeiLabel		= " "
		cubeSortType	= "{@cubeSortType}"
		gokeiSortDir	= "{@gokeiSortDir}"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
