/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.io;

import org.jfree.chart.plot.Plot;

/**
 * <p>ChartPlot は、org.jfree.chart.plot.Plot オブジェクトを構築するクラスの共通インターフェースです。
 * 複数の ChartDataset オブジェクトを合成することも、ここで行っています。
 * グラフの種類は、チャートタイプの指定によって、ChartPlot_XXX クラスで設定しています。
 * これらのクラスを共通に使用するためのインターフェースクラスです。
 *
 * @version  0.9.0	2007/06/21
 * @author	 Kazuhiko Hasegawa
 * @since	 JDK1.1,
 */
public interface ChartPlot {

	/**
	 * Plot オブジェクトを取得します。
	 *
	 * Plot オブジェクト には、その種類の応じた、データセットやレンデラーを
	 * 設定する必要があります。
	 * また、複数のデータセットや、それに関係する属性情報も、設定する必要が
	 * あります。
	 * Plot は、JFreeChart オブジェクトにつき、一つ用意しなければなりません。
	 * チャート合成時でも、Plot は一つです。
	 *
	 * @param	chartCreate ChartCreate オブジェクト
	 * @return	Plot オブジェクト
	 */
	Plot getPlot( final ChartCreate chartCreate ) ;
}
