/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGAttributes;


/**
 * query.jspの&lttr&gt&ltog:column&gtタグを作成します。<br />
 * 
 * ●使用例<br />
 *		 JspConvertEntity e = new JspConvertEntity();<br />
 * 		e.setTableName("GF92");<br />
 * 		e.setColumnName("CLM");<br />
 * 		List< JspConvertEntity> a = new List< JspConvertEntity>();<br />
 * 		a.add( e );<br />
 * 		HashMap< String , List< JspConvertEntity> > m = new HashMap< String , List<JspConvertEntity> >();<br />
 * 		m.put( "ORDER", a );<br />
 * 		JspTakeout_OG_COLUMN j = new JspTakeout_OG_COLUMN( m );<br /> 
 * 		j.execute("&lt;og:column /&gt");
 * 
 * @author Administrator
 *
 */
public class JspCreate_OG_COLUMN extends AbstractJspCreate {
	private List<JspConvertEntity> QUERY_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 * 
	 * 内部で使用する JspConvertEntity の List のマップを受け取り、初期化を行います。
	 * 
	 * @param master Map<String,List<JspConvertEntity>>
	 */
	protected void init( Map<String,List<JspConvertEntity>> master ) {
		QUERY_ROWS = master.get("QUERY");
		IS_NULL = (QUERY_ROWS == null || QUERY_ROWS.isEmpty() );
		KEY  = "table";
		NAME = "query";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 * 
	 * @param attr OGAttributes エレメントの属性オブジェクト
	 * @return String 変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGAttributes attr )  throws Throwable {
		if( IS_NULL ) { return ""; }

		// TODO Auto-generated method stub
		//書き出す文字列を作成開始。
		StringBuilder sbTub = new StringBuilder();
		//JOIN情報から<og:condition>タグの検索句を生成する準備をします。
		sbTub.append( "<table summary=\"layout\">" ).append( CR );
		int iTdCount = 0;
		for ( JspConvertEntity column : QUERY_ROWS ) {
			if (iTdCount == 3) {
				iTdCount = 0;
			}
			if(iTdCount == 0){
				sbTub.append( "<tr>" ).append( CR );
			}
			sbTub.append( "\t<og:column name=\"" );
			sbTub.append( column.getColumnName() );
			sbTub.append( "\"" );
			if ( column.getDefaultValue() != null && column.getDefaultValue().trim().length() > 0) {
				sbTub.append( " defaultVal=\"");
				sbTub.append( column.getDefaultValue() );		
				sbTub.append( "\" ");
			}
			if ( "1".equals( column.getMust() )){
				sbTub.append( " must=\"true\" ");
			}
			sbTub.append( " />" ).append( CR );
			if(iTdCount == 2){
				sbTub.append( "</tr>" ).append( CR );
			}
			iTdCount++;
		}
		if ( iTdCount < 3 ){
			sbTub.append( "</tr>" ).append( CR );
		}
		sbTub.append( "</table>" ).append( CR );

		return sbTub.toString();
	}
}
