/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.BufferedReader;
import org.opengion.fukurou.util.CSVTokenizer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractTableReader
implements TableReader {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private String separator = "\t";
    private ResourceManager resource = null;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    protected DBTableModel table = null;
    protected DBColumn[] dbColumn = null;
    protected String columns = null;
    private String encode = null;
    private boolean useNumber = true;
    private int skipRowCount = 0;

    @Override
    public abstract void readDBTable();

    @Override
    public abstract void readDBTable(BufferedReader var1);

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    protected void setTableDBColumn(String[] stringArray) {
        this.dbColumn = new DBColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DBColumn dBColumn = this.resource.makeDBColumn(stringArray[i]);
            this.table.setDBColumn(i, dBColumn);
            this.dbColumn[i] = dBColumn;
        }
    }

    protected String[] readData(String string, int n) {
        String[] stringArray = new String[n];
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, this.separator.charAt(0));
        if (this.useNumber) {
            cSVTokenizer.nextToken();
        }
        int n2 = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            String string2 = StringUtil.csvOutQuote((String)cSVTokenizer.nextToken());
            stringArray[n2++] = string2 != null && string2.startsWith("'0") ? StringUtil.rTrim((String)string2.substring(1)) : StringUtil.rTrim((String)string2);
            if (n2 < n) continue;
            break;
        }
        for (int i = n2; i < n; ++i) {
            stringArray[i] = "";
        }
        return stringArray;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    @Override
    public void setSheetName(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public boolean isExcel() {
        return false;
    }

    @Override
    public void setFilename(String string) {
        String string2 = "\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public void setColumns(String string) {
        this.columns = string;
    }

    @Override
    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    @Override
    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }
}

