<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page isErrorPage = "true" />
<jsp:scriptlet>
	ErrorData err = pageContext.getErrorData();
	String url = request.getContextPath() + "/jsp/";
	int statusCode = err.getStatusCode();

	// 401の場合はコードを送る必要がある
	if( statusCode == 401 ){
		response.addHeader("WWW-Authenticate", "BASIC realm=\"Web App\"");
		response.setStatus(statusCode);
	}
</jsp:scriptlet>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="Content-Style-Type" content="text/css" />
<og:text>
    <link rel="stylesheet" href="{@SYS.JSP}/common/default.css"  type="text/css" />
    <link rel="stylesheet" href="{@SYS.JSP}/custom/custom.css"   type="text/css" />
    <title>{@SESSION.GUI_TITLE}</title>
</og:text>
<style type="text/css">
	#time{
		text-align:right;
		color: #ee7777;
	}
	#msg{
		text-align:center;
	}
</style>
</head>
<body>
<div id="time">
	<og:text value="{@SYS.DATE}" />
</div>

<jsp:scriptlet>
	if( statusCode == 401 ){
		out.println("&lt;div id='msg'&gt;");
		out.println("認証に失敗しました。");
		out.println("&lt;/div&gt;");
	}
	else if( statusCode == 403 || statusCode ==404 ){
		out.println("&lt;div id='msg'&gt;");
		out.println("画面が存在しないか、アクセス権限がありません。");
		out.println("&lt;/div&gt;");
	}
	else{
</jsp:scriptlet>
		<og:error viewMsgType="TABLE" />
<jsp:scriptlet>
//		out.println("エラーです。システム管理者にご連絡下さい。");
	}
</jsp:scriptlet>

</body></html>
</jsp:root>
