/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.JspIncludeReader;

public class XSLT {
    private static final String CR = System.getProperty("line.separator");
    public static final String ENCODE = "UTF-8";
    private Transformer transformer = null;
    private String encode = "UTF-8";
    private String xmlFile = null;
    private String xslFile = null;
    private String outFile = null;
    private Reader xslReader = null;
    private Writer outWriter = null;
    private HybsEntry[] paramEntry = null;
    private boolean isFileInfo = false;
    private boolean isErrClose = true;
    private boolean isErrXmlIn = false;
    private boolean isInclude = true;
    private StreamResult result = null;
    private DateFormat formatter = null;
    private String jspIncludeData = null;

    public void setXslFile(String string) {
        this.xslFile = string;
        this.setXslFile(FileUtil.getBufferedReader(new File(this.xslFile), this.encode));
    }

    public void setXslFile(Reader reader) {
        this.transformer = null;
        this.xslReader = reader;
    }

    public void setOutFile(String string, boolean bl) {
        this.outFile = string;
        this.setOutFile(FileUtil.getPrintWriter(new File(this.outFile), this.encode, bl));
    }

    public void setOutFile(Writer writer) {
        Closer.ioClose(this.outWriter);
        this.outWriter = writer;
        this.result = new StreamResult(this.outWriter);
    }

    public void setOutData(String string) {
        if (string != null && string.length() > 0) {
            try {
                this.outWriter.write(string);
                this.outWriter.write(CR);
            }
            catch (IOException iOException) {
                String string2 = "\u30e9\u30a4\u30bf\u30fc\u306b\u30c7\u30fc\u30bf\u767b\u9332\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + iOException.getMessage();
                this.close();
                throw new RuntimeException(string2, iOException);
            }
        }
    }

    public void transform(String string) {
        this.transform(string, this.isInclude);
    }

    public void transform(String string, boolean bl) {
        this.xmlFile = string;
        if (this.xmlFile.endsWith(".jsp") && bl) {
            this.jspIncludeData = new JspIncludeReader().getString(new File(this.xmlFile), this.encode, false);
            this.transform(new StringReader(this.jspIncludeData));
        } else {
            this.transform(FileUtil.getBufferedReader(new File(this.xmlFile), this.encode));
        }
    }

    public void transform(Reader reader) {
        HybsEntry[] hybsEntryArray = null;
        try {
            if (this.transformer == null) {
                this.init();
            } else {
                this.transformer.reset();
            }
            if (this.isFileInfo && this.xmlFile != null) {
                hybsEntryArray = this.getXmlParameter(this.xmlFile);
                this.parameterSet(this.transformer, hybsEntryArray);
            }
            this.xmlFile = null;
            StreamSource streamSource = new StreamSource(reader);
            this.transformer.transform(streamSource, this.result);
        }
        catch (TransformerException transformerException) {
            String string = "XML-XSLT \u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + transformerException.getMessage();
            if (this.isErrXmlIn) {
                this.setOutData(this.toXmlRow(hybsEntryArray, transformerException));
            }
            if (this.isErrClose) {
                this.close();
            }
            throw new RuntimeException(string, transformerException);
        }
        finally {
            Closer.ioClose(reader);
        }
    }

    public void setParamEntry(HybsEntry[] hybsEntryArray) {
        if (hybsEntryArray != null && hybsEntryArray.length > 0) {
            this.paramEntry = new HybsEntry[hybsEntryArray.length];
            System.arraycopy(hybsEntryArray, 0, this.paramEntry, 0, hybsEntryArray.length);
        }
    }

    public void errClose(boolean bl) {
        this.isErrClose = bl;
    }

    public void useErrXmlIn(boolean bl) {
        this.isErrXmlIn = bl;
    }

    public void jspInclude(boolean bl) {
        this.isInclude = bl;
    }

    public void close() {
        Closer.ioClose(this.outWriter);
    }

    private void init() {
        try {
            StreamSource streamSource = new StreamSource(this.xslReader);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transformer = transformerFactory.newTransformer(streamSource);
            this.parameterSet(this.transformer, this.paramEntry);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = this.xslFile + "\u30d5\u30a1\u30a4\u30eb\u306e XSLT \u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + transformerConfigurationException.getMessage();
            throw new RuntimeException(string, transformerConfigurationException);
        }
        finally {
            Closer.ioClose(this.xslReader);
            this.xslReader = null;
        }
    }

    public void useFileInfo(boolean bl) {
        this.isFileInfo = bl;
        if (this.isFileInfo) {
            this.formatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.JAPAN);
        }
    }

    public void useEncode(String string) {
        this.encode = string;
    }

    private HybsEntry[] getXmlParameter(String string) {
        HybsEntry[] hybsEntryArray = new HybsEntry[4];
        hybsEntryArray[0] = new HybsEntry("FILEPATH", string);
        File file = new File(string);
        hybsEntryArray[1] = new HybsEntry("FILENAME", file.getName());
        File file2 = file.getParentFile();
        hybsEntryArray[2] = file2 != null ? new HybsEntry("ADDRESS", file2.getName()) : new HybsEntry("ADDRESS", "");
        String string2 = this.formatter.format(new Date(file.lastModified()));
        hybsEntryArray[3] = new HybsEntry("MODIFIED", string2);
        return hybsEntryArray;
    }

    private void parameterSet(Transformer transformer, HybsEntry[] hybsEntryArray) {
        if (hybsEntryArray != null) {
            int n = hybsEntryArray.length;
            for (int i = 0; i < n; ++i) {
                String string = hybsEntryArray[i].getKey();
                String string2 = hybsEntryArray[i].getValue();
                transformer.setParameter(string, string2);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XSL File:").append(this.xslFile).append(CR);
        stringBuilder.append("XML File:").append(this.xmlFile).append(CR);
        stringBuilder.append("OUT File:").append(this.outFile).append(CR);
        return stringBuilder.toString();
    }

    private String toXmlRow(HybsEntry[] hybsEntryArray, TransformerException transformerException) {
        String string;
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ROW>").append(CR);
        if (this.paramEntry != null) {
            for (n = 0; n < this.paramEntry.length; ++n) {
                string2 = this.paramEntry[n].getKey();
                string = this.paramEntry[n].getValue();
                stringBuilder.append("  <").append(string2).append(">");
                stringBuilder.append(string);
                stringBuilder.append("</").append(string2).append(">");
                stringBuilder.append(CR);
            }
        }
        if (hybsEntryArray != null) {
            for (n = 0; n < hybsEntryArray.length; ++n) {
                string2 = hybsEntryArray[n].getKey();
                string = hybsEntryArray[n].getValue();
                stringBuilder.append("  <").append(string2).append(">");
                stringBuilder.append(string);
                stringBuilder.append("</").append(string2).append(">");
                stringBuilder.append(CR);
            }
        }
        stringBuilder.append("  <TAGNAME />").append(CR);
        stringBuilder.append("  <MSGCD>XML_ERROR</MSGCD>").append(CR);
        stringBuilder.append("  <MSGTXT>XML-XSLT \u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002</MSGTXT>").append(CR);
        String string3 = StringUtil.htmlFilter(transformerException.getMessage());
        int n2 = string3.lastIndexOf("Exception:");
        if (n2 >= 0) {
            string3 = string3.substring(n2 + "Exception:".length());
        }
        stringBuilder.append("  <TEXT>").append(string3).append(CR);
        stringBuilder.append(" Location:").append(transformerException.getLocationAsString()).append(CR);
        if (this.jspIncludeData != null) {
            stringBuilder.append(StringUtil.htmlFilter(this.jspIncludeData));
        }
        stringBuilder.append("</TEXT>").append(CR);
        stringBuilder.append("</ROW>").append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            LogWriter.log("Usage: java XSLT in_xml in_xsl out_xml");
            LogWriter.log("  XML \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u3001XSL \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u9069\u7528\u3057\u3066\u3001");
            LogWriter.log("  XSLT\u5909\u63db\u3092\u884c\u3044\u307e\u3059\u3002");
            LogWriter.log("  \u7d50\u679c\u306f\u3001XML \u30d5\u30a1\u30a4\u30eb\u306b\u30bb\u30fc\u30d6\u3057\u307e\u3059\u3002");
            LogWriter.log("  out_xml \u306b System.out \u3092\u6307\u5b9a\u3059\u308b\u3068\u6a19\u6e96\u51fa\u529b\u306b\u51fa\u529b\u3057\u307e\u3059\u3002");
            return;
        }
        XSLT xSLT = new XSLT();
        xSLT.setXslFile(stringArray[1]);
        xSLT.setOutFile(stringArray[2], false);
        xSLT.transform(stringArray[0]);
        xSLT.close();
    }
}

