// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++  Move one list contents to another list                       ++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function switchListOpts(oListFrom, oListTo, bSelectedOnly , inVal ) {
	var nIndexUp;
	var nLastIdx;
	var bMoveIt;

	with ( oListFrom ) {
		for (nIndexUp = 0; nIndexUp < length; nIndexUp++) {
			//if( inVal != null ) {
			if( inVal ) {
				bMoveIt = ( inVal == options[nIndexUp].value );
			}
			else {
				bMoveIt = ((bSelectedOnly) ?  options[nIndexUp].selected : true);
			}

			if (bMoveIt) {
				nLastIdx = nIndexUp;
				with (options[nIndexUp]) {
					var flag    = true;
					for( nidx=0; nidx < oListTo.length; nidx++ ) {
						if( oListTo.options[nidx].value == value ) {
							flag = false;
							break;
						}
					}
					if( flag ) {
						oListTo.options[oListTo.length] = new Option( text, value );
					}
				} 
				options[nIndexUp] = null;
				nIndexUp--;
			} 
		}
		//if( inVal == null ) {
		if( inVal ) {
			if (options[nLastIdx] != null) {
				options[nLastIdx].selected = true;
			}
			else if( length > 0 && options[length-1] != null) {
				options[length-1].selected = true;
			}
		}
	}
}

function moveListOpts(oList, nCmd) {
	var nIndexUp, nCountUp, nInc;
	var nTotalLen;

	switch(nCmd) {
	case 1:
	case 2:
		with (oList) {
			nInc	 = ((1 == nCmd) ? -1 : 1);
			// Note : Begin from index 1
			for (nCountUp = 1; nCountUp < options.length; nCountUp++) {
				nIndexUp = ((1 == nCmd) ? nCountUp : (options.length - nCountUp -1));
				if(options[nIndexUp].selected) {
					if( !options[nIndexUp + nInc].selected) {
						//options[nIndexUp + nInc].swapNode(options[nIndexUp]);
						var oBaseNade = ((nInc > 0) ? options[nIndexUp] : options[nIndexUp].nextSibling);
						insertBefore(removeChild(options[nIndexUp + nInc]), oBaseNade);
					}
				} 
			}
			break;
		} 
	case 3:
		with (oList) {
			// Note : Begin from index 0
			nTotalLen = children.length;
			nCountUp = -1;
			nIndexUp = nTotalLen;
			while (++nCountUp < nTotalLen) {
				nIndexUp--;
				if(children[nIndexUp].selected) {
					insertBefore(removeChild(children[nIndexUp]), children[0]);
					nIndexUp++;
				}
			}
		} 
		break;

	 case 4:
		with (oList) {
			// Note : Begin from index 0
			nTotalLen = children.length;
			nCountUp = -1;
			nIndexUp = -1;
			while (++nCountUp < nTotalLen) {
				nIndexUp++;
				if(children[nIndexUp].selected) {
					appendChild(removeChild(children[nIndexUp]));
					nIndexUp--;
				}
			}
		} 
		break;
	default:
		break;
	 }
}

function makeCSV( listTo,inText,splt ) {
	if( inText == null ) { return; }
	var csvList = "";

	if( listTo.length > 0 ) {
		csvList = listTo.options[0].value;

		// Note : Begin from index 1
		for( nidx=1; nidx < listTo.length; nidx++ ) {
			csvList += splt + listTo.options[nidx].value
		}
	}
	inText.value = csvList;
}


function initOpts(oListFrom, oListTo, inVals, splt ) {
	if( inVals != null ) {
		var vals = inVals.split( splt );
		for ( var i=0; i < vals.length; i++) {
			switchListOpts(oListFrom, oListTo, true , vals[i] );
		}
	}
}
