/***************************************************************************
 * 入力欄の簡易チェック(リアルタイム)
 * DBTYPE に応じた簡易チェックを行います。あくまで簡易的なチェックです。
 * 大文字小文字などは、JavaScriptで変換できる為、チェックは行いません。
 *
 * @og.rev 4.3.3.0 (2008/10/01) サーバーサイドのリアルタイムチェック対応
 * @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)
 * @og.rev 4.3.6.6 (2009/05/15) bodyに追加し、いつも上に表示
 * @og.rev 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。
 * @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
 * Revision: $Id$
 ***************************************************************************/
var isShowTip = false;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ check( this, '../common/realtimecheck.jsp' ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ check( this, '../common/realtimecheck.jsp' ); } );

	// 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。
	$('table#viewTable').parent().parent().scroll( function () {
		if( isShowTip ) { isShowTip = false; $(".tipErr").remove(); }
	});
});

function check( obj, sUrl ) {
	var val = obj.value;
	var cls = obj.className;
	var msg = null;

	if (typeof jQuery != "undefined") {
		var sFullFN = obj.name;
		var arrFName = sFullFN.split('__');
		var bTMCheck = (2 == arrFName.length)
//		var sParam = "command=RTCHECK&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" )
		var sParam = "command=RENEW&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" ) // 4.3.4.0 (2008/12/01)
				   + ( bTMCheck ? "&h_rowSel=" + arrFName[1] : "" )
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + val;
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURI( val ); // 4.3.4.0 (2008/12/01)
				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURIComponent( val ); // 5.2.0.0 (2010/09/01)
		var ajaxSettings = {   
				dataType : 'html',
				type	 : 'POST',
				url		 : sUrl,
				data	 : sParam
		};

		ajaxSettings.error = function() {};
		ajaxSettings.success = function(data) {
			//Remove old msg
//			var sOutId = getTipId(obj);
//			$("#" + sOutId).remove();
			var tipId = $(obj).data( "tipId" );
			$("#" + tipId).remove();

			if( $.trim(data).indexOf("row_error") >= 0 ) {
				showCheckTip( obj, data );
				isShowTip = true;
			}
		};
		$.ajax(ajaxSettings);
  }

	return true;
}

/* Revised From jTip Plug-in of jQuery */
function showCheckTip( oEditOut, content ) {
	var jEditOut = $(oEditOut);
	var hEditOffset = jEditOut.offset();

	var sJtDiv = "<div class='tipErr'><div id='tipArrowBottom'></div><div>" + content + "</div></div>";
	var jJtDiv = $(sJtDiv).appendTo(document.body);

	//set x position
	var clickElementx = hEditOffset.left; 
	//set y position
	var clickElementy = hEditOffset.top + (-11 - jJtDiv[0].offsetHeight);

	var tipId = (new Date()).getTime();
	$(oEditOut).data( "tipId", tipId );

	jJtDiv.css( { left: clickElementx+"px", top: clickElementy+"px" } )
			.attr( 'id', tipId )
			.click( function() { $(this).remove(); } )
			.show();
}

//function getTipId(oEdit) {
//	return "JT" + $.data(oEdit);
//}