/**************************************************************************/
/* GF82 ( DBオブジェクト一覧テーブル )                                    */
/*                                                                        */
/* Created : 2010/08/05 08:49:52                                          */
/**************************************************************************/
CREATE TABLE GF82 (
   SYSTEM_ID VARCHAR(10)                 NOT NULL                  /* 10  システムID         */
 , TBLSYU    VARCHAR(1)                  NOT NULL                  /* 20  テーブル種別       */
 , OBJ_TYPE  VARCHAR(20)                 NOT NULL                  /* 30  オブジェクトタイプ */
 , OBJ_NAME  VARCHAR(30)                 NOT NULL                  /* 40  オブジェクト名     */
 , NAME_JA   VARCHAR(200)                                          /* 50  名称               */
 , STTS      VARCHAR(7)                                            /* 60  ステータス         */
 , UNIQ      BIGINT                      NOT NULL PRIMARY KEY      /* 800 ユニークキー       */
 , FGJ       VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 810 状態フラグ         */
 , DYSET     VARCHAR(14)                                           /* 820 登録日時           */
 , PGSET     VARCHAR(10)                                           /* 830 作成PG             */
 , PGPSET    VARCHAR(10)                                           /* 840 作成親PG           */
 , USRSET    VARCHAR(10)                                           /* 850 作成社員           */
 , DYUPD     VARCHAR(14)                                           /* 860 更新日時           */
 , PGUPD     VARCHAR(10)                                           /* 870 更新PG             */
 , PGPUPD    VARCHAR(10)                                           /* 880 更新親PG           */
 , USRUPD    VARCHAR(10)                                           /* 890 更新者             */
);

CREATE SEQUENCE GF82S00 ;


CREATE TRIGGER GF82T00 FOR GF82
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF82S00,1 );
  END; 


