<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2000"
	title	= "テーブルスペース"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "SYSTEM_ID"
/>

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select '2' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID,
				TABLESPACE_NAME,TABLESPACE_NAME AS NAME_JA,
				FILE_NAME, 
				BYTES/(1024*1024) AS SIZE_DATA,
				(CASE STATUS WHEN 'AVAILABLE' THEN 1 ELSE 0 END) AS STATUS
		from DBA_DATA_FILES
		order by TABLESPACE_NAME
	</jsp:text>
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
<br />
</og:writeCheck>

<og:view
	viewFormType	= "HTMLTable"
	command			= "NEW"
	columnWritable	= "NAME_JA"
	checked			= "true"
	startNo			= "{@startNo}"
	pageSize		= "10000"
/>

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GF01
		(TBLSYU,TABLESPACE_NAME,NAME_JA,FILE_NAME,
		 SIZE_DATA,STATUS,SYSTEM_ID,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([TBLSYU],[TABLESPACE_NAME],[NAME_JA],[FILE_NAME],
		 [SIZE_DATA],[STATUS],[SYSTEM_ID],
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
  </jsp:text>
</og:hidden>

<og:hidden name="SQL2" >
  <jsp:text>
	DELETE FROM GF01 WHERE SYSTEM_ID = [SYSTEM_ID] AND TBLSYU = [TBLSYU] AND TABLESPACE_NAME = [TABLESPACE_NAME]
  </jsp:text>
</og:hidden>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
