<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- DEFAULTのDBIDは削除不可 -->
<og:equals val1="{@MEM.TYPE}" val2="DBID">
	<og:equals val1="{@command}" val2="REALDELETE">
		<og:dataCheck command="ENTRY" msg="GEE0004">
			[dbidkey] != 'DEFAULT'
		</og:dataCheck>
	</og:equals>
</og:equals>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" strictCheck="false" />

<og:equals val1="{@MEM.TYPE}" val2="DBID">
	<og:dataCheck command="{@command}" uniqCheckClms="dbidKey" selectedAll="true" />
</og:equals>
<og:equals val1="{@MEM.TYPE}" val2="DBCLASS">
	<og:dataCheck command="{@command}" uniqCheckClms="class" selectedAll="true" />
</og:equals>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
